/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.tpsdetective;

import com.mojang.logging.LogUtils;
import io.github.catomon.tpsdetective.Config;
import io.github.catomon.tpsdetective.DetectiveScreen;
import io.github.catomon.tpsdetective.ServerEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static boolean froze = false;
    private static Long warningTime = 0L;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (!((Boolean)Config.isOn.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.START && mc.f_91073_ != null) {
            LOGGER.debug("[Tick Detective] Client tick start detected.");
            if (mc.m_91104_()) {
                LOGGER.debug("[Tick Detective] Game is paused - skipping freeze check.");
                ServerEvents.lastServerTick = System.currentTimeMillis();
                return;
            }
            long now = System.currentTimeMillis();
            long delta = now - ServerEvents.lastServerTick;
            LOGGER.debug("[Tick Detective] Time since last server tick: {} ms", (Object)delta);
            if (delta > 10000L) {
                if (!froze) {
                    froze = true;
                    LOGGER.info("[Tick Detective] Freeze detected - opening DetectiveScreen.");
                    mc.m_91152_((Screen)new DetectiveScreen());
                }
            } else if (froze) {
                LOGGER.info("[Tick Detective] Tick activity resumed - closing freeze state.");
                froze = false;
            }
        } else if (event.phase == TickEvent.Phase.END) {
            LOGGER.trace("[Tick Detective] Client tick end phase reached.");
        }
        LocalPlayer player = mc.f_91074_;
        if (player != null && (warningTime = Long.valueOf(warningTime + 1L)) > 12000L) {
            warningTime = 0L;
            MutableComponent message = Component.m_237113_((String)"[TPS Detective] Client warning: Detective was working for some time now. If it's not needed anymore, turn it off by going to Mods -> TPS Detective -> Config.");
            player.m_213846_((Component)message);
        }
    }
}

