/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.tpsdetective;

import io.github.catomon.tpsdetective.Config;
import io.github.catomon.tpsdetective.Detective;
import io.github.catomon.tpsdetective.LagGoal;
import io.github.catomon.tpsdetective.TickProfiler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class DetectiveScreen
extends Screen {
    private final List<Entity> infoList;
    private final List<Component> displayComponents = new ArrayList<Component>();
    private int currentPage = 0;
    private final int linesPerPage = 12;

    public DetectiveScreen() {
        super((Component)Component.m_237115_((String)"screen.tps_detective.detective_screen"));
        this.infoList = Detective.combineEntitiesOrderedByJoinStackAndTick();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.displayComponents.clear();
        TextColor red = TextColor.m_131266_((int)0xFF5555);
        TextColor orange = TextColor.m_131266_((int)0xFFAA00);
        TextColor white = TextColor.m_131266_((int)0xFFFFFF);
        if (Detective.structureInProcess) {
            this.displayComponents.add((Component)Component.m_237113_((String)(Detective.lastStructStartId + " <- Unfinished structure")).m_130938_(style -> style.m_131148_(red)));
        }
        Entity entityStuckTicking = Detective.lastTickedEntity;
        if (Detective.entityTicking && entityStuckTicking != null) {
            String entityName = entityStuckTicking.m_7755_().getString();
            ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_((Object)entityStuckTicking.m_6095_());
            String modId = id.toString();
            String entityText = entityName + " / " + modId;
            this.displayComponents.add((Component)Component.m_237113_((String)(entityText + " <- Unfinished ticking")).m_130938_(style -> style.m_131148_(red)));
        } else {
            entityStuckTicking = null;
        }
        ArrayList<Entity> lastlyTickedEntities = new ArrayList<Entity>();
        ArrayList<Entity> otherEntities = new ArrayList<Entity>();
        Entity lastTickedEntity = null;
        Long lastTickedEntityTickTime = null;
        for (Entity entity : this.infoList) {
            if (Detective.lastTickStartTimes.get(entity) == null) continue;
            lastTickedEntity = entity;
            lastTickedEntityTickTime = Detective.lastTickStartTimes.get(lastTickedEntity);
            break;
        }
        if (lastTickedEntity == null) {
            otherEntities.addAll(this.infoList);
        } else {
            for (Entity entity : this.infoList) {
                Long tick = Detective.lastTickStartTimes.get(entity);
                if (entity.equals((Object)entityStuckTicking)) continue;
                if (tick != null && tick.equals(lastTickedEntityTickTime)) {
                    lastlyTickedEntities.add(entity);
                    continue;
                }
                otherEntities.add(entity);
            }
        }
        otherEntities.sort((e1, e2) -> {
            long sum1 = Detective.entityProfilers.getOrDefault(e1, new TickProfiler(0, 0)).getRecentTickDurations().stream().mapToLong(Long::longValue).sum();
            long sum2 = Detective.entityProfilers.getOrDefault(e2, new TickProfiler(0, 0)).getRecentTickDurations().stream().mapToLong(Long::longValue).sum();
            if (sum1 == 0L && sum2 == 0L) {
                return 0;
            }
            if (sum1 == 0L) {
                return -1;
            }
            if (sum2 == 0L) {
                return 1;
            }
            return Long.compare(sum2, sum1);
        });
        ArrayList<Entity> sortedEntities = new ArrayList<Entity>();
        sortedEntities.addAll(lastlyTickedEntities);
        sortedEntities.addAll(otherEntities);
        for (Entity entity : sortedEntities) {
            Object lineText = entity.m_7755_().getString();
            ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_());
            String modId = id.toString();
            lineText = (String)lineText + " / " + modId;
            if (lastlyTickedEntities.contains(entity)) {
                lineText = (String)lineText + " <- Last ticked";
            } else if (Detective.lastTickStartTimes.get(entity) == null) {
                lineText = (String)lineText + " <- Not ticked yet";
            }
            if (Config.IS_DEBUG && LagGoal.theCause != null && LagGoal.theCause.equals((Object)entity)) {
                lineText = (String)lineText + " <*";
            }
            long ticksNanoSum = Detective.entityProfilers.getOrDefault(entity, new TickProfiler(0, 0)).getRecentTickDurations().stream().mapToLong(Long::longValue).sum();
            lineText = (String)lineText + " " + ticksNanoSum / 1000000L + "ms/10s";
            TextColor color = lastlyTickedEntities.contains(entity) ? orange : (Detective.lastTickStartTimes.get(entity) == null ? orange : white);
            this.displayComponents.add((Component)Component.m_237113_((String)lineText).m_130938_(style -> style.m_131148_(color)));
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> this.m_7379_()).m_252987_(20, this.f_96544_ - 40, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"< Prev"), button -> {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        }).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 40, 80, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Next >"), button -> {
            if ((this.currentPage + 1) * 12 < sortedEntities.size()) {
                ++this.currentPage;
            }
        }).m_252987_(this.f_96543_ / 2 + 20, this.f_96544_ - 40, 80, 20).m_253136_());
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        int startY = 50;
        int lineHeight = 12;
        int startIndex = this.currentPage * 12;
        int endIndex = Math.min(startIndex + 12, this.displayComponents.size());
        for (int i = startIndex; i < endIndex; ++i) {
            guiGraphics.m_280653_(this.f_96547_, this.displayComponents.get(i), this.f_96543_ / 2, startY + (i - startIndex) * lineHeight, 0);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return true;
    }
}

