/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.endervillages.ModEffects;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.InstantenousMobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

public class TeleportEffect
extends InstantenousMobEffect {
    public TeleportEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void applyInstantenousEffect(ServerLevel p_365989_, @Nullable Entity p_298495_, @Nullable Entity p_298887_, LivingEntity entityLiving, int amplifier, double p_298163_) {
        Level level;
        if (!entityLiving.level().isClientSide() && (level = entityLiving.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            for (int i = 0; i < 16; ++i) {
                int baseRange = 50 * (amplifier + 1);
                double x = entityLiving.getX() + (entityLiving.getRandom().nextDouble() - 0.5) * (double)baseRange * 2.0;
                double y = Mth.clamp((double)(entityLiving.getY() + (double)(entityLiving.getRandom().nextInt(16 + amplifier * 4) - 8)), (double)level2.getMinY(), (double)(level2.getMinY() + level2.getLogicalHeight() - 1));
                double z = entityLiving.getZ() + (entityLiving.getRandom().nextDouble() - 0.5) * (double)baseRange * 2.0;
                if (entityLiving.isPassenger()) {
                    entityLiving.stopRiding();
                }
                Vec3 vec3 = entityLiving.position();
                EntityTeleportEvent.TeleportCommand event = EventHooks.onEntityTeleportCommand((Entity)entityLiving, (double)x, (double)y, (double)z);
                if (event == null) {
                    return;
                }
                if (!entityLiving.randomTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
                level2.gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)entityLiving));
                SoundEvent sound = entityLiving instanceof Fox ? SoundEvents.FOX_TELEPORT : SoundEvents.CHORUS_FRUIT_TELEPORT;
                SoundSource sourceType = entityLiving instanceof Fox ? SoundSource.NEUTRAL : SoundSource.PLAYERS;
                level2.playSound(null, entityLiving.getX(), entityLiving.getY(), entityLiving.getZ(), sound, sourceType, 1.0f, 1.0f);
                entityLiving.resetFallDistance();
                break;
            }
        }
    }
}

