/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.endervillages.block;

import java.util.function.Supplier;
import net.baffledbanana87.endervillages.block.custom.DragonFruitBlock;
import net.baffledbanana87.endervillages.block.custom.EndBrewingStandBlock;
import net.baffledbanana87.endervillages.block.custom.EndCropBlock;
import net.baffledbanana87.endervillages.block.custom.EnderCarrotBlock;
import net.baffledbanana87.endervillages.block.custom.EnderPotatoBlock;
import net.baffledbanana87.endervillages.block.custom.WarpEnchantingBlock;
import net.baffledbanana87.endervillages.item.ModItems;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlock {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"endervillages");
    public static final RegistryObject<Block> WARP_BLOCK = ModBlock.registerBlock("warp_block", () -> new Block(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"endervillages", (String)"warp_block"))).mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.COW_BELL).strength(0.5f).sound(SoundType.SOUL_SAND)));
    public static final RegistryObject<Block> END_PATH_BLOCK = ModBlock.registerBlock("end_path", () -> new Block(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"endervillages", (String)"end_path"))).mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.COW_BELL).strength(0.5f).sound(SoundType.SOUL_SAND)));
    public static final RegistryObject<Block> END_COMPOSTER = ModBlock.registerBlock("end_composter", () -> new ComposterBlock(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"endervillages", (String)"end_composter"))).mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(0.6f).sound(SoundType.WOOD).ignitedByLava()));
    public static final RegistryObject<Block> ENDER_CARROT = ModBlock.registerBlock("ender_carrots", () -> new EnderCarrotBlock(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"endervillages", (String)"ender_carrots"))).mapColor(MapColor.PLANT).noCollission().randomTicks().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY)));
    public static final RegistryObject<Block> DRAGON_PLANT = ModBlock.registerBlock("dragon_plant", () -> new DragonFruitBlock(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"endervillages", (String)"dragon_plant"))).mapColor(MapColor.PLANT).randomTicks().strength(0.5f).sound(SoundType.CROP)));
    public static final RegistryObject<Block> ENDER_POTATO = ModBlock.registerBlock("ender_potatoes", () -> new EnderPotatoBlock(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"endervillages", (String)"ender_potatoes"))).mapColor(MapColor.PLANT).noCollission().randomTicks().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY)));
    public static final RegistryObject<HayBlock> END_HAY_BLOCK = ModBlock.registerBlock("end_hay_block", () -> new HayBlock(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"endervillages", (String)"end_hay_block"))).mapColor(MapColor.COLOR_YELLOW).instrument(NoteBlockInstrument.BANJO).strength(0.5f).sound(SoundType.GRASS)));
    public static final RegistryObject<Block> ENDER_WHEAT = ModBlock.registerBlock("end_wheat", () -> new EndCropBlock(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"endervillages", (String)"end_wheat"))).mapColor(MapColor.PLANT).noCollission().randomTicks().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY)));
    public static final RegistryObject<Block> WARP_ENCHANTING_TABLE = ModBlock.registerBlock("warp_enchanting_table", () -> new WarpEnchantingBlock(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"endervillages", (String)"warp_enchanting_table"))).mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASEDRUM).lightLevel(p_152692_ -> 7).strength(-1.0f, 3600000.0f).noLootTable()));
    public static final RegistryObject<Block> LILY_OF_THE_END = ModBlock.registerBlock("lily_of_the_end", () -> new FlowerBlock(MobEffects.POISON, 12.0f, BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"endervillages", (String)"lily_of_the_end"))).mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)));
    public static final RegistryObject<Block> ENDER_BREWING_STAND = ModBlock.registerBlock("end_brewing_stand", () -> new EndBrewingStandBlock(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"endervillages", (String)"end_brewing_stand"))).mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(0.5f).lightLevel(p_50856_ -> 1).noOcclusion()));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlock.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"endervillages", (String)name)))));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

