/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.endervillages.entity.client.end_golem;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.baffledbanana87.endervillages.entity.client.end_golem.EndGolemEyeLayer;
import net.baffledbanana87.endervillages.entity.custom.end_golem.EndGolem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.IronGolemModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.IronGolemRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class EndGolemRenderer
extends MobRenderer<EndGolem, IronGolemRenderState, IronGolemModel> {
    private static final ResourceLocation GOLEM_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"endervillages", (String)"textures/entity/end_golem.png");

    public EndGolemRenderer(EntityRendererProvider.Context p_174188_) {
        super(p_174188_, (EntityModel)new IronGolemModel(p_174188_.bakeLayer(ModelLayers.IRON_GOLEM)), 0.7f);
        this.addLayer((RenderLayer)new EndGolemEyeLayer((RenderLayerParent<IronGolemRenderState, IronGolemModel>)this));
    }

    public ResourceLocation getTextureLocation(IronGolemRenderState p_362874_) {
        return GOLEM_LOCATION;
    }

    public IronGolemRenderState createRenderState() {
        return new IronGolemRenderState();
    }

    public void extractRenderState(EndGolem p_367018_, IronGolemRenderState p_363683_, float p_363302_) {
        super.extractRenderState((LivingEntity)p_367018_, (LivingEntityRenderState)p_363683_, p_363302_);
        p_363683_.attackTicksRemaining = (float)p_367018_.getAttackAnimationTick() > 0.0f ? (float)p_367018_.getAttackAnimationTick() - p_363302_ : 0.0f;
        p_363683_.offerFlowerTick = p_367018_.getOfferFlowerTick();
        p_363683_.crackiness = p_367018_.getCrackiness();
    }

    protected void setupRotations(IronGolemRenderState p_366774_, PoseStack p_115015_, float p_115016_, float p_115017_) {
        super.setupRotations((LivingEntityRenderState)p_366774_, p_115015_, p_115016_, p_115017_);
        if (!((double)p_366774_.walkAnimationSpeed < 0.01)) {
            float f = 13.0f;
            float f1 = p_366774_.walkAnimationPos + 6.0f;
            float f2 = (Math.abs(f1 % 13.0f - 6.5f) - 3.25f) / 3.25f;
            p_115015_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(6.5f * f2));
        }
    }
}

