/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.endervillages.entity.client.end_villager;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.VillagerLikeModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.VillagerDataHolderRenderState;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.VillagerMetadataSection;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModVillagerProfessionLayer<S extends LivingEntityRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    private static final Int2ObjectMap<ResourceLocation> LEVEL_LOCATIONS = (Int2ObjectMap)Util.make((Object)new Int2ObjectOpenHashMap(), p_340946_ -> {
        p_340946_.put(1, (Object)ResourceLocation.withDefaultNamespace((String)"stone"));
        p_340946_.put(2, (Object)ResourceLocation.withDefaultNamespace((String)"iron"));
        p_340946_.put(3, (Object)ResourceLocation.withDefaultNamespace((String)"gold"));
        p_340946_.put(4, (Object)ResourceLocation.withDefaultNamespace((String)"emerald"));
        p_340946_.put(5, (Object)ResourceLocation.withDefaultNamespace((String)"diamond"));
    });
    private final Object2ObjectMap<ResourceKey<VillagerType>, VillagerMetadataSection.Hat> typeHatCache = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<ResourceKey<VillagerProfession>, VillagerMetadataSection.Hat> professionHatCache = new Object2ObjectOpenHashMap();
    private final ResourceManager resourceManager;
    private final String path;

    public ModVillagerProfessionLayer(RenderLayerParent<S, M> p_174550_, ResourceManager p_174551_, String p_174552_) {
        super(p_174550_);
        this.resourceManager = p_174551_;
        this.path = p_174552_;
    }

    public void render(PoseStack p_117646_, MultiBufferSource p_117647_, int p_117648_, S p_369199_, float p_117650_, float p_117651_) {
        VillagerData villagerdata;
        if (!((LivingEntityRenderState)p_369199_).isInvisible && (villagerdata = ((VillagerDataHolderRenderState)p_369199_).getVillagerData()) != null) {
            Holder holder = villagerdata.type();
            Holder holder1 = villagerdata.profession();
            VillagerMetadataSection.Hat villagermetadatasection$hat = this.getHatData(this.typeHatCache, "type", holder);
            VillagerMetadataSection.Hat villagermetadatasection$hat1 = this.getHatData(this.professionHatCache, "profession", holder1);
            EntityModel m = this.getParentModel();
            ((VillagerLikeModel)m).hatVisible(villagermetadatasection$hat1 == VillagerMetadataSection.Hat.NONE || villagermetadatasection$hat1 == VillagerMetadataSection.Hat.PARTIAL && villagermetadatasection$hat != VillagerMetadataSection.Hat.FULL);
            ResourceLocation resourcelocation = ResourceLocation.fromNamespaceAndPath((String)"endervillages", (String)"textures/entity/type/ender_plains.png");
            ModVillagerProfessionLayer.renderColoredCutoutModel((EntityModel)m, (ResourceLocation)resourcelocation, (PoseStack)p_117646_, (MultiBufferSource)p_117647_, (int)p_117648_, p_369199_, (int)-1);
            ((VillagerLikeModel)m).hatVisible(true);
            if (!holder1.is(VillagerProfession.NONE) && !((LivingEntityRenderState)p_369199_).isBaby) {
                ResourceLocation resourcelocation1 = this.getResourceLocation("profession", holder1);
                ModVillagerProfessionLayer.renderColoredCutoutModel((EntityModel)m, (ResourceLocation)resourcelocation1, (PoseStack)p_117646_, (MultiBufferSource)p_117647_, (int)p_117648_, p_369199_, (int)-1);
                if (!holder1.is(VillagerProfession.NITWIT)) {
                    ResourceLocation resourcelocation2 = this.getResourceLocation("profession_level", (ResourceLocation)LEVEL_LOCATIONS.get(Mth.clamp((int)villagerdata.level(), (int)1, (int)LEVEL_LOCATIONS.size())));
                    ModVillagerProfessionLayer.renderColoredCutoutModel((EntityModel)m, (ResourceLocation)resourcelocation2, (PoseStack)p_117646_, (MultiBufferSource)p_117647_, (int)p_117648_, p_369199_, (int)-1);
                }
            }
        }
    }

    private ResourceLocation getResourceLocation(String p_117669_, ResourceLocation p_117670_) {
        return p_117670_.withPath(p_247944_ -> "textures/entity/" + this.path + "/" + p_117669_ + "/" + p_247944_ + ".png");
    }

    private ResourceLocation getResourceLocation(String p_394986_, Holder<?> p_393109_) {
        return p_393109_.unwrapKey().map(p_389520_ -> this.getResourceLocation(p_394986_, p_389520_.location())).orElse(MissingTextureAtlasSprite.getLocation());
    }

    public <K> VillagerMetadataSection.Hat getHatData(Object2ObjectMap<ResourceKey<K>, VillagerMetadataSection.Hat> p_117659_, String p_117660_, Holder<K> p_394605_) {
        ResourceKey resourcekey = p_394605_.unwrapKey().orElse(null);
        return resourcekey == null ? VillagerMetadataSection.Hat.NONE : (VillagerMetadataSection.Hat)p_117659_.computeIfAbsent((Object)resourcekey, p_389523_ -> this.resourceManager.getResource(this.getResourceLocation(p_117660_, resourcekey.location())).flatMap(p_374659_ -> {
            try {
                return p_374659_.metadata().getSection(VillagerMetadataSection.TYPE).map(VillagerMetadataSection::hat);
            }
            catch (IOException ioexception) {
                return Optional.empty();
            }
        }).orElse(VillagerMetadataSection.Hat.NONE));
    }
}

