/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.endervillages.block;

import java.util.function.Supplier;
import net.baffledbanana87.endervillages.block.custom.DragonFruitBlock;
import net.baffledbanana87.endervillages.block.custom.EndBrewingStandBlock;
import net.baffledbanana87.endervillages.block.custom.EndCropBlock;
import net.baffledbanana87.endervillages.block.custom.EnderCarrotBlock;
import net.baffledbanana87.endervillages.block.custom.EnderPotatoBlock;
import net.baffledbanana87.endervillages.block.custom.WarpEnchantingBlock;
import net.baffledbanana87.endervillages.item.ModItems;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlock {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"endervillages");
    public static final RegistryObject<Block> WARP_BLOCK = ModBlock.registerBlock("warp_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_280658_(NoteBlockInstrument.COW_BELL).m_60978_(0.5f).m_60918_(SoundType.f_56716_)));
    public static final RegistryObject<Block> END_PATH_BLOCK = ModBlock.registerBlock("end_path", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_280658_(NoteBlockInstrument.COW_BELL).m_60978_(0.5f).m_60918_(SoundType.f_56716_)));
    public static final RegistryObject<Block> END_COMPOSTER = ModBlock.registerBlock("end_composter", () -> new ComposterBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(0.6f).m_60918_(SoundType.f_56736_).m_278183_()));
    public static final RegistryObject<Block> ENDER_CARROT = ModBlock.registerBlock("ender_carrots", () -> new EnderCarrotBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56758_).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> DRAGON_PLANT = ModBlock.registerBlock("dragon_plant", () -> new DragonFruitBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60977_().m_60978_(0.5f).m_60918_(SoundType.f_56758_)));
    public static final RegistryObject<Block> ENDER_POTATO = ModBlock.registerBlock("ender_potatoes", () -> new EnderPotatoBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56758_).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<HayBlock> END_HAY_BLOCK = ModBlock.registerBlock("end_hay_block", () -> new HayBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280658_(NoteBlockInstrument.BANJO).m_60978_(0.5f).m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<Block> ENDER_WHEAT = ModBlock.registerBlock("end_wheat", () -> new EndCropBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56758_).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> WARP_ENCHANTING_TABLE = ModBlock.registerBlock("warp_enchanting_table", () -> new WarpEnchantingBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283913_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60953_(p_152692_ -> 7).m_60913_(-1.0f, 3600000.0f).m_222994_()));
    public static final RegistryObject<Block> LILY_OF_THE_END = ModBlock.registerBlock("lily_of_the_end", () -> new FlowerBlock(MobEffects.f_19614_, 12, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> ENDER_BREWING_STAND = ModBlock.registerBlock("end_brewing_stand", () -> new EndBrewingStandBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60999_().m_60978_(0.5f).m_60953_(p_50856_ -> 1).m_60955_()));
    public static final RegistryObject<Block> END_TOOLSMITH_TABLE = ModBlock.registerBlock("end_toolsmith_table", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.5f)));
    public static final RegistryObject<Block> END_ARMOR_TABLE = ModBlock.registerBlock("end_armor_table", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.5f)));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlock.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

