/*
 * Decompiled with CFR 0.152.
 */
package galena.doom_and_gloom.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;

public class DGReloadListener
extends class_4080<List<Integer>> {
    public static final List<Integer> STONE_TABLET_TEXT_COLORS = new ArrayList<Integer>();

    public static int getColor() {
        return STONE_TABLET_TEXT_COLORS.get(0);
    }

    public static int getDarkColor() {
        return STONE_TABLET_TEXT_COLORS.get(1);
    }

    public static int getLightColor() {
        return STONE_TABLET_TEXT_COLORS.get(2);
    }

    protected List<Integer> prepare(class_3300 pResourceManager, class_3695 pProfiler) {
        return DGReloadListener.parsePaletteStrip(pResourceManager, new class_2960("doom_and_gloom:textures/misc/stone_tablet_text_colors.png"), 3);
    }

    protected void apply(List<Integer> pObject, class_3300 pResourceManager, class_3695 pProfiler) {
        STONE_TABLET_TEXT_COLORS.clear();
        STONE_TABLET_TEXT_COLORS.addAll(pObject);
    }

    public static List<Integer> parsePaletteStrip(class_3300 manager, class_2960 fullTexturePath, int expectColors) {
        ArrayList<Integer> arrayList;
        block9: {
            class_1011 image = DGReloadListener.readImage(manager, fullTexturePath);
            try {
                ArrayList<Integer> list = new ArrayList<Integer>();
                DGReloadListener.forEachPixel(image, (x, y) -> {
                    int i = image.method_4315(x.intValue(), y.intValue());
                    if (i == 0 || list.size() >= expectColors) {
                        return;
                    }
                    list.add(DGReloadListener.swapFormat(i));
                });
                if (list.size() < expectColors) {
                    throw new RuntimeException("Image at " + String.valueOf(fullTexturePath) + " has too few colors! Expected at least " + expectColors + " and got " + list.size());
                }
                arrayList = list;
                if (image == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (image != null) {
                        try {
                            image.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NoSuchElementException e) {
                    throw new RuntimeException("Failed to find image at location " + String.valueOf(fullTexturePath), e);
                }
            }
            image.close();
        }
        return arrayList;
    }

    public static int swapFormat(int argb) {
        return argb & 0xFF00FF00 | argb >> 16 & 0xFF | argb << 16 & 0xFF0000;
    }

    public static class_1011 readImage(class_3300 manager, class_2960 resourceLocation) throws IOException, NoSuchElementException {
        class_1011 class_10112;
        block8: {
            InputStream res = ((class_3298)manager.method_14486(resourceLocation).get()).method_14482();
            try {
                class_10112 = class_1011.method_4309((InputStream)res);
                if (res == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            res.close();
        }
        return class_10112;
    }

    public static void forEachPixel(class_1011 image, BiConsumer<Integer, Integer> function) {
        for (int y = 0; y < image.method_4323(); ++y) {
            for (int x = 0; x < image.method_4307(); ++x) {
                function.accept(x, y);
            }
        }
    }
}

