/*
 * Decompiled with CFR 0.152.
 */
package galena.doom_and_gloom.client;

import galena.doom_and_gloom.DoomAndGloom;
import galena.doom_and_gloom.client.DGModelLayers;
import galena.doom_and_gloom.client.DGReloadListener;
import galena.doom_and_gloom.client.DGRenderTypes;
import galena.doom_and_gloom.client.model.DirtMoundModel;
import galena.doom_and_gloom.client.model.HollerModel;
import galena.doom_and_gloom.client.particle.BoneFragmentParticle;
import galena.doom_and_gloom.client.particle.FogParticle;
import galena.doom_and_gloom.client.render.entity.DirtMoundRenderer;
import galena.doom_and_gloom.client.render.entity.HollerRender;
import galena.doom_and_gloom.client.screen.StoneTabletScreen;
import galena.doom_and_gloom.content.block.StoneTabletBlockEntity;
import galena.doom_and_gloom.index.DGBlocks;
import galena.doom_and_gloom.index.DGEntityTypes;
import galena.doom_and_gloom.index.DGParticleTypes;
import net.mehvahdjukaar.moonlight.api.client.CoreShaderContainer;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4956;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_727;
import net.minecraft.class_746;

public class DoomAndGloomClient {
    public static void init() {
        ClientHelper.addClientReloadListener(DGReloadListener::new, (class_2960)DoomAndGloom.modLoc("tablets_reloader"));
        ClientHelper.addEntityRenderersRegistration(DoomAndGloomClient::registerEntityRenderers);
        ClientHelper.addModelLayerRegistration(DoomAndGloomClient::registerModelLayers);
        ClientHelper.addShaderRegistration(DoomAndGloomClient::registerShaders);
        ClientHelper.addClientSetup(DoomAndGloomClient::setup);
        ClientHelper.addParticleRegistration(DoomAndGloomClient::registerParticleFactories);
    }

    public static void setup() {
        class_1921 cutout = class_1921.method_23581();
        ClientHelper.registerRenderType((class_2248)((class_2248)DGBlocks.SEPULCHER.get()), (class_1921)cutout);
        DGBlocks.vigilCandles().forEach(block -> ClientHelper.registerRenderType((class_2248)((class_2248)block.get()), (class_1921)cutout));
    }

    public static void registerShaders(ClientHelper.ShaderEvent event) {
        event.register(DoomAndGloom.modLoc("rendertype_entity_translucent_additive"), class_290.field_1580, arg_0 -> ((CoreShaderContainer)DGRenderTypes.NO_ALPHA_CUTOFF_SHADER).assign(arg_0));
    }

    private static void registerEntityRenderers(ClientHelper.EntityRendererEvent event) {
        event.register((class_1299)DGEntityTypes.HOLLER.get(), HollerRender::new);
        event.register((class_1299)DGEntityTypes.DIRT_MOUND.get(), DirtMoundRenderer::new);
    }

    public static void registerModelLayers(ClientHelper.ModelLayerEvent event) {
        event.register(DGModelLayers.HOLLER, HollerModel::createBodyLayer);
        event.register(DGModelLayers.DIRT_MOUND, DirtMoundModel::createBodyLayer);
    }

    public static void registerParticleFactories(ClientHelper.ParticleEvent event) {
        event.register((class_2396)((class_2400)DGParticleTypes.BONE_FRAGMENT.get()), BoneFragmentParticle.Provider::new);
        event.register((class_2396)((class_2400)DGParticleTypes.FOG.get()), sprites -> new FogParticle.Provider(sprites, 200));
        event.register((class_2396)((class_2400)DGParticleTypes.FOG_WATER.get()), sprites -> new FogParticle.Provider(sprites, 100));
        event.register((class_2396)((class_2400)DGParticleTypes.HOLLERING_SOUL.get()), class_4956.class_4957::new);
    }

    public static void spawnConsumeParticles(class_243 at) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_702 particles = class_310.method_1551().field_1713;
        class_2680 state = ((class_2248)DGBlocks.ROTTING_FLESH.get()).method_9564();
        for (int i = 0; i < 20; ++i) {
            class_243 vec = at.method_1031(level.field_9229.method_43058() - 0.5, level.field_9229.method_43058() * 2.0, level.field_9229.method_43058() - 0.5);
            particles.method_3058((class_703)new class_727(level, vec.field_1352, vec.field_1351, vec.field_1350, 0.0, 0.0, 0.0, state));
        }
    }

    public static void openStoneTabletScreen(class_2338 pos) {
        class_2586 class_25862;
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        class_746 player = mc.field_1724;
        if (level != null && player != null && (class_25862 = level.method_8321(pos)) instanceof StoneTabletBlockEntity) {
            StoneTabletBlockEntity tile = (StoneTabletBlockEntity)class_25862;
            class_1799 stack = player.method_5998(player.method_6058());
            mc.method_1507((class_437)new StoneTabletScreen(tile, stack, mc.method_33883()));
        }
    }
}

