/*
 * Decompiled with CFR 0.152.
 */
package galena.doom_and_gloom.client.screen;

import galena.doom_and_gloom.DoomAndGloom;
import galena.doom_and_gloom.client.DGReloadListener;
import galena.doom_and_gloom.content.block.StoneTabletBlock;
import galena.doom_and_gloom.content.block.StoneTabletBlockEntity;
import galena.doom_and_gloom.content.block.StoneTabletText;
import galena.doom_and_gloom.index.DGItems;
import galena.doom_and_gloom.network.DGNetwork;
import galena.doom_and_gloom.network.packet.StoneTabletUpdatePacket;
import java.util.stream.IntStream;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3728;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;

public class StoneTabletScreen
extends class_437 {
    private static final class_2960 BACKGROUND = DoomAndGloom.modLoc("textures/gui/tablet.png");
    private final StoneTabletBlockEntity tablet;
    private final int maxLines;
    private final boolean canEdit;
    private StoneTabletText text;
    private final String[] messages;
    private int frame;
    private int line;
    @Nullable
    private class_3728 signField;
    private boolean engraveOnClose = false;

    public StoneTabletScreen(StoneTabletBlockEntity tablet, class_1799 stack, boolean isFiltered) {
        super((class_2561)class_2561.method_43473());
        this.tablet = tablet;
        this.text = tablet.getText();
        this.maxLines = tablet.getText().getLineCount();
        this.messages = (String[])IntStream.range(0, this.maxLines).mapToObj(i -> this.text.getMessage(i, isFiltered)).map(class_2561::getString).toArray(String[]::new);
        this.canEdit = tablet.type == StoneTabletBlock.Type.DEFAULT && stack.method_31574((class_1792)DGItems.BUSH_HAMMER.get());
    }

    protected void method_25426() {
        if (!this.canEdit) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.onDone()).method_46434(this.field_22789 / 2 - 100, this.field_22790 / 4 + 144, 200, 20).method_46431());
        } else {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.doom_and_gloom.stone_tablet.engrave"), p_98177_ -> this.onEngrave()).method_46434(this.field_22789 / 2 - 100, 196, 98, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.doom_and_gloom.stone_tablet.cancel"), p_280851_ -> this.onDone()).method_46434(this.field_22789 / 2 + 2, 196, 98, 20).method_46431());
        }
        this.signField = new class_3728(() -> this.messages[this.line], this::setMessage, class_3728.method_27550((class_310)this.field_22787), class_3728.method_27561((class_310)this.field_22787), string -> this.field_22787.field_1772.method_1727(string) <= this.tablet.getMaxTextLineWidth());
    }

    public void method_25393() {
        if (this.canEdit) {
            ++this.frame;
        }
        if (!this.isValid()) {
            this.onDone();
        }
    }

    private boolean isValid() {
        return this.field_22787 != null && this.field_22787.field_1724 != null && !this.tablet.method_11015() && !this.tablet.playerIsTooFarAwayToEdit(this.field_22787.field_1724.method_5667());
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.canEdit) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (keyCode == 265) {
            this.line = (this.line - 1 + this.maxLines) % this.maxLines;
            this.signField.method_16204();
            return true;
        }
        if (keyCode == 264 || keyCode == 257 || keyCode == 335) {
            this.line = (this.line + 1) % this.maxLines;
            this.signField.method_16204();
            return true;
        }
        return this.signField.method_16202(keyCode) || super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.canEdit) {
            this.signField.method_16199(codePoint);
        }
        return this.canEdit;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_308.method_24210();
        this.method_25420(guiGraphics);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 40, 0xFFFFFF);
        this.renderSign(guiGraphics);
        class_308.method_24211();
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void method_25419() {
        this.onDone();
    }

    public void method_25432() {
        if (this.engraveOnClose) {
            DGNetwork.CHANNEL.sendToServer((Message)new StoneTabletUpdatePacket(this.tablet.method_11016(), this.messages));
        }
    }

    public boolean method_25421() {
        return false;
    }

    private void renderSign(class_332 guiGraphics) {
        guiGraphics.method_51448().method_22903();
        int imageWidth = 152;
        int imageHeight = 184;
        guiGraphics.method_51448().method_46416((float)this.field_22789 / 2.0f, 100.0f, 50.0f);
        guiGraphics.method_25302(BACKGROUND, -imageWidth / 2, -imageHeight / 2, 0, 0, imageWidth, imageHeight);
        this.renderText(guiGraphics);
        guiGraphics.method_51448().method_22909();
    }

    private void renderText(class_332 guiGraphics) {
        String string;
        int n;
        guiGraphics.method_51448().method_46416(0.0f, -5.0f, 4.0f);
        int color = DGReloadListener.getColor();
        int darkColor2 = DGReloadListener.getLightColor();
        int darkColor = DGReloadListener.getDarkColor();
        boolean showCursor = this.frame / 6 % 2 == 0 && this.canEdit;
        int j = this.signField.method_16201();
        int k = this.signField.method_16203();
        int l = this.maxLines * this.tablet.getTextLineHeight() / 2;
        int m = this.line * this.tablet.getTextLineHeight() - l;
        for (n = 0; n < this.messages.length; ++n) {
            string = this.messages[n];
            if (string == null) continue;
            if (this.field_22793.method_1726()) {
                string = this.field_22793.method_1721(string);
            }
            int pX = -this.field_22793.method_1727(string) / 2 - 1;
            int pY = n * this.tablet.getTextLineHeight() - l;
            this.drawEngravedString(guiGraphics, string, pX, pY, color, darkColor2, darkColor);
            if (n != this.line || j < 0 || !showCursor) continue;
            int p = this.field_22793.method_1727(string.substring(0, Math.max(Math.min(j, string.length()), 0)));
            int q = p - this.field_22793.method_1727(string) / 2;
            if (j < string.length()) continue;
            guiGraphics.method_51433(this.field_22793, "_", q, m, darkColor, false);
        }
        for (n = 0; n < this.messages.length; ++n) {
            string = this.messages[n];
            if (string == null || n != this.line || j < 0) continue;
            int o = this.field_22793.method_1727(string.substring(0, Math.max(Math.min(j, string.length()), 0)));
            int p = o - this.field_22793.method_1727(string) / 2;
            if (showCursor && j < string.length()) {
                guiGraphics.method_25294(p, m - 1, p + 1, m + this.tablet.getTextLineHeight(), 0xFF000000 | color);
            }
            if (k == j) continue;
            int q = Math.min(j, k);
            int r = Math.max(j, k);
            int s = this.field_22793.method_1727(string.substring(0, q)) - this.field_22793.method_1727(string) / 2;
            int t = this.field_22793.method_1727(string.substring(0, r)) - this.field_22793.method_1727(string) / 2;
            int u = Math.min(s, t);
            int v = Math.max(s, t);
            guiGraphics.method_51739(class_1921.method_51786(), u, m, v, m + this.tablet.getTextLineHeight(), -16776961);
        }
    }

    private void drawEngravedString(class_332 guiGraphics, String string, int pX, int pY, int normal, int dark, int light) {
        class_4587 pose = guiGraphics.method_51448();
        pose.method_22903();
        guiGraphics.method_51433(this.field_22793, string, pX, pY, normal, false);
        pose.method_46416(0.0f, 0.0f, -1.0f);
        guiGraphics.method_51433(this.field_22793, string, pX - 1, pY - 1, dark, false);
        guiGraphics.method_51433(this.field_22793, string, pX, pY - 1, dark, false);
        guiGraphics.method_51433(this.field_22793, string, pX - 1, pY, dark, false);
        pose.method_46416(0.0f, 0.0f, -1.0f);
        guiGraphics.method_51433(this.field_22793, string, pX + 1, pY + 1, light, false);
        guiGraphics.method_51433(this.field_22793, string, pX + 1, pY, light, false);
        guiGraphics.method_51433(this.field_22793, string, pX, pY + 1, light, false);
        guiGraphics.method_51433(this.field_22793, string, pX + 2, pY + 1, light, false);
        guiGraphics.method_51433(this.field_22793, string, pX - 1, pY + 1, light, false);
        guiGraphics.method_51433(this.field_22793, string, pX - 1, pY, light, false);
        guiGraphics.method_51433(this.field_22793, string, pX - 1, pY - 1, light, false);
        pose.method_22909();
    }

    private void setMessage(String message) {
        this.messages[this.line] = message;
        this.text = this.text.withMessage(this.line, (class_2561)class_2561.method_43470((String)message));
    }

    private void onDone() {
        this.field_22787.method_1507(null);
    }

    private void onEngrave() {
        this.tablet.setText(this.text);
        this.engraveOnClose = true;
        this.field_22787.method_1507(null);
    }
}

