/*
 * Decompiled with CFR 0.152.
 */
package galena.doom_and_gloom.compat.moonlight;

import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import galena.doom_and_gloom.compat.moonlight.MoonlightCompat;
import galena.doom_and_gloom.index.DGTags;
import java.util.Map;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4097;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4208;

public class LightUpCandles
extends class_4097<class_1646> {
    private final float speedModifier;
    private int ticksSinceReached = 0;
    private int cooldown = 200;
    protected int lastBreakProgress = -1;
    protected class_4208 targetPos = null;
    private static final GameProfile GRAVETENDER = new GameProfile(UUID.fromString("f3f3f3f3-2233-f3f3-f3f3-f3f3f3f3f3f3"), "[Gravetender]");

    public LightUpCandles(float speed) {
        super((Map)ImmutableMap.of((Object)class_4140.field_18447, (Object)class_4141.field_18457, MoonlightCompat.NEAREST_UNLIT_CANDLE.get(), (Object)class_4141.field_18456, (Object)class_4140.field_18445, (Object)class_4141.field_18457), 270, 350);
        this.speedModifier = speed * 1.1f;
    }

    protected boolean checkExtraStartConditions(class_3218 pLevel, class_1646 pOwner) {
        class_4208 globalpos;
        if (this.cooldown-- > 0) {
            return false;
        }
        if (!PlatHelper.isMobGriefingOn((class_1937)pLevel, (class_1297)pOwner)) {
            this.cooldown = 1200;
            return false;
        }
        this.targetPos = globalpos = (class_4208)pOwner.method_18868().method_18904(MoonlightCompat.NEAREST_UNLIT_CANDLE.get()).get();
        return globalpos.method_19442() == pLevel.method_27983();
    }

    protected void start(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        this.cooldown = 20 * (5 + pLevel.field_9229.method_43048(20)) + pLevel.field_9229.method_43048(20);
        this.ticksSinceReached = 0;
        this.lastBreakProgress = -1;
        pEntity.method_18868().method_18875(class_4140.field_18447);
        pEntity.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(this.targetPos.method_19446(), this.speedModifier, 1));
    }

    protected void stop(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        super.method_18926(pLevel, (class_1309)pEntity, pGameTime);
    }

    protected boolean canStillUse(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        return pEntity.method_18868().method_18896(MoonlightCompat.NEAREST_UNLIT_CANDLE.get());
    }

    protected void tick(class_3218 level, class_1646 pOwner, long pGameTime) {
        class_2338 pos = this.targetPos.method_19446();
        pOwner.method_18868().method_18875(class_4140.field_18447);
        pOwner.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(pos, this.speedModifier, 2));
        pOwner.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(pos));
        if (pos.method_19769((class_2374)pOwner.method_19538(), 2.3)) {
            ++this.ticksSinceReached;
            class_2680 state = level.method_8320(pos);
            if (!state.method_26164(DGTags.Blocks.GRAVETENDER_LIGHTABLE)) {
                pOwner.method_18868().method_18875(MoonlightCompat.NEAREST_UNLIT_CANDLE.get());
            } else {
                int k = (int)((float)this.ticksSinceReached / 20.0f * 10.0f);
                if (k != this.lastBreakProgress) {
                    this.lastBreakProgress = k;
                }
                if (this.ticksSinceReached > 20) {
                    class_1657 player = FakePlayerManager.get((GameProfile)GRAVETENDER, (class_1937)level);
                    class_1799 itemStack = class_1802.field_8884.method_7854();
                    player.method_6122(class_1268.field_5808, itemStack);
                    class_3965 hit = new class_3965(class_243.method_24955((class_2382)pos), class_2350.field_11036, pos, false);
                    if (!itemStack.method_7981(new class_1838(player, class_1268.field_5808, hit)).method_23665()) {
                        state.method_26174((class_1937)level, player, class_1268.field_5808, hit);
                    }
                    pOwner.method_18868().method_18875(class_4140.field_18446);
                }
            }
        }
    }
}

