/*
 * Decompiled with CFR 0.152.
 */
package galena.doom_and_gloom.content.block;

import galena.doom_and_gloom.content.block.TickingEntityBlock;
import galena.doom_and_gloom.content.entity.SepulcherBlockEntity;
import galena.doom_and_gloom.index.DGBlockEntities;
import galena.doom_and_gloom.index.DGBlocks;
import galena.doom_and_gloom.index.DGSoundEvents;
import java.awt.Color;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4174;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class SepulcherBlock
extends class_2248
implements TickingEntityBlock<SepulcherBlockEntity> {
    public static final int MAX_LEVEL = 13;
    public static final int SEALED_LEVELS = 5;
    public static final int READY = 18;
    public static final class_2758 LEVEL = class_2758.method_11867((String)"level", (int)0, (int)18);
    private static final class_265 OUTER_SHAPE = class_259.method_1077();
    private static final class_265[] SHAPES = (class_265[])class_156.method_654((Object)new class_265[14], shapes -> {
        for (int level = 0; level < ((class_265[])shapes).length; ++level) {
            shapes[level] = class_259.method_1072((class_265)OUTER_SHAPE, (class_265)class_2248.method_9541((double)2.0, (double)Math.max(2, 1 + level), (double)2.0, (double)14.0, (double)16.0, (double)14.0), (class_247)class_247.field_16886);
        }
    });

    public SepulcherBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{LEVEL});
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        int fillLevel = (Integer)state.method_11654((class_2769)LEVEL);
        if (fillLevel == 18) {
            SepulcherBlock.extract((class_1297)player, state, level, pos);
            return class_1269.method_29236((boolean)level.method_8608());
        }
        class_1799 held = player.method_5998(hand);
        if (SepulcherBlock.tryInsert(held, player, state, level, pos, false)) {
            player.method_7259(class_3468.field_15372.method_14956((Object)held.method_7909()));
            if (!player.method_31549().field_7477) {
                held.method_7934(1);
            }
            return class_1269.method_29236((boolean)level.method_8608());
        }
        return class_1269.field_5811;
    }

    public static boolean tryInsert(class_1799 stack, @Nullable class_1657 player, class_2680 state, class_1937 level, class_2338 pos, boolean simulate) {
        int fillLevel = (Integer)state.method_11654((class_2769)LEVEL);
        class_4174 food = stack.method_7909().method_19264();
        if (fillLevel < 13 && food != null && food.method_19232()) {
            if (!simulate) {
                SepulcherBlock.insert((class_1297)player, state, level, pos, level.field_9229.method_39332(1, 2));
            }
            return true;
        }
        return false;
    }

    public static void insert(@Nullable class_1297 user, class_2680 state, class_1937 level, class_2338 pos, int by) {
        class_2680 newState = (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(Math.min(13, (Integer)state.method_11654((class_2769)LEVEL) + by)));
        level.method_8652(pos, newState, 3);
        level.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)user, (class_2680)newState));
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_243 vec = class_243.method_24953((class_2382)pos);
            serverLevel.method_14199((class_2394)class_2398.field_17741, vec.field_1352, vec.field_1351, vec.field_1350, 10, 0.3, 0.3, 0.3, 0.0);
        }
        level.method_8396(null, pos, (class_3414)DGSoundEvents.SEPULCHER_FILLED.get(), class_3419.field_15245, 0.5f, 1.0f);
    }

    public static void extract(@Nullable class_1297 user, class_2680 state, class_1937 level, class_2338 pos) {
        if (!level.method_8608()) {
            class_243 vec = class_243.method_49273((class_2382)pos, (double)0.5, (double)1.01, (double)0.5).method_49272(level.field_9229, 0.7f);
            class_1542 item = new class_1542(level, vec.method_10216(), vec.method_10214(), vec.method_10215(), new class_1799((class_1935)DGBlocks.BONE_PILE.get()));
            item.method_6988();
            level.method_8649((class_1297)item);
        }
        SepulcherBlock.clear(user, state, level, pos);
    }

    public static void spawnRottingParticles(class_2338 at) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        Color effectColor = new Color(8889187);
        for (int i = 0; i < 20; ++i) {
            class_243 vec = class_243.method_24955((class_2382)at).method_1031(level.field_9229.method_43058() - 0.5, 0.8, level.field_9229.method_43058() - 0.5);
            level.method_8406((class_2394)class_2398.field_11226, vec.field_1352, vec.field_1351, vec.field_1350, (double)effectColor.getRed() / 255.0, (double)effectColor.getGreen() / 255.0, (double)effectColor.getBlue() / 255.0);
        }
    }

    public static void clear(@Nullable class_1297 user, class_2680 state, class_1937 level, class_2338 pos) {
        class_2680 empty = (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0));
        level.method_8501(pos, empty);
        level.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)user, (class_2680)empty));
        level.method_8396(null, pos, (class_3414)DGSoundEvents.SEPULCHER_HARVEST.get(), class_3419.field_15245, 1.0f, 1.0f);
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        int fillLevel = (Integer)state.method_11654((class_2769)LEVEL);
        if (fillLevel == 18) {
            return SHAPES[0];
        }
        if (fillLevel > 13) {
            return OUTER_SHAPE;
        }
        return SHAPES[fillLevel];
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SepulcherBlockEntity(pos, state);
    }

    @Override
    public class_2591<SepulcherBlockEntity> getType() {
        return (class_2591)DGBlockEntities.SEPULCHER.get();
    }
}

