/*
 * Decompiled with CFR 0.152.
 */
package galena.doom_and_gloom.content.block;

import galena.doom_and_gloom.content.block.StoneTabletBlockEntity;
import galena.doom_and_gloom.content.block.StoneTabletText;
import galena.doom_and_gloom.content.block.TickingEntityBlock;
import galena.doom_and_gloom.index.DGBlockEntities;
import galena.doom_and_gloom.index.DGBlocks;
import galena.doom_and_gloom.network.DGNetwork;
import galena.doom_and_gloom.network.packet.EngraveStoneTabletPacket;
import java.util.Arrays;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;

public class StoneTabletBlock
extends class_2248
implements class_3737,
TickingEntityBlock<StoneTabletBlockEntity> {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<Attachment> ATTACHMENT = class_2754.method_11850((String)"attachment", Attachment.class);
    protected static final class_265 SHAPE_Z = class_2248.method_9541((double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)16.0, (double)14.0);
    protected static final class_265 SHAPE_X = class_2248.method_9541((double)2.0, (double)0.0, (double)6.0, (double)14.0, (double)16.0, (double)10.0);
    protected static final class_265 SHAPE_SOUTH = class_2248.method_9541((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)4.0);
    protected static final class_265 SHAPE_NORTH = class_2248.method_9541((double)2.0, (double)0.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0);
    protected static final class_265 SHAPE_EAST = class_2248.method_9541((double)0.0, (double)0.0, (double)2.0, (double)4.0, (double)16.0, (double)14.0);
    protected static final class_265 SHAPE_WEST = class_2248.method_9541((double)12.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    protected static final class_265 SHAPE_FLOOR_Z = class_2248.method_9541((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)4.0, (double)16.0);
    protected static final class_265 SHAPE_FLOOR_X = class_2248.method_9541((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)4.0, (double)14.0);
    protected static final class_265 SHAPE_CEILING_Z = class_2248.method_9541((double)2.0, (double)12.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    protected static final class_265 SHAPE_CEILING_X = class_2248.method_9541((double)0.0, (double)12.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    public final Type type;

    public StoneTabletBlock(class_4970.class_2251 properties, Type type) {
        super(properties);
        this.type = type;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(ATTACHMENT, (Comparable)((Object)Attachment.CENTER_UPRIGHT)));
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2338 pos = context.method_8037();
        boolean water = context.method_8045().method_8316(pos).method_15772() == class_3612.field_15910;
        class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(water));
        class_1937 level = context.method_8045();
        class_2350 clickFace = context.method_8038();
        if (clickFace.method_10166() == class_2350.class_2351.field_11052) {
            class_2680 below = level.method_8320(pos.method_10093(clickFace.method_10153()));
            if (below.method_26204() instanceof StoneTabletBlock && ((Attachment)((Object)below.method_11654(ATTACHMENT))).isUpright()) {
                return (class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)((class_2350)below.method_11654((class_2769)FACING)))).method_11657(ATTACHMENT, (Comparable)((Object)((Attachment)((Object)below.method_11654(ATTACHMENT)))));
            }
            class_1657 p = context.method_8036();
            if (p != null && p.method_5715()) {
                return (class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153())).method_11657(ATTACHMENT, (Comparable)((Object)(clickFace == class_2350.field_11036 ? Attachment.FLOOR : Attachment.CEILING)));
            }
            return (class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153())).method_11657(ATTACHMENT, (Comparable)((Object)Attachment.CENTER_UPRIGHT));
        }
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)clickFace)).method_11657(ATTACHMENT, (Comparable)((Object)Attachment.WALL));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{WATERLOGGED, FACING, ATTACHMENT});
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return super.method_9559(state, facing, facingState, level, currentPos, facingPos);
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return switch ((Attachment)((Object)state.method_11654(ATTACHMENT))) {
            default -> throw new IncompatibleClassChangeError();
            case Attachment.FLOOR -> {
                switch ((class_2350)state.method_11654((class_2769)FACING)) {
                    case field_11043: 
                    case field_11035: {
                        yield SHAPE_FLOOR_Z;
                    }
                }
                yield SHAPE_FLOOR_X;
            }
            case Attachment.CEILING -> {
                switch ((class_2350)state.method_11654((class_2769)FACING)) {
                    case field_11043: 
                    case field_11035: {
                        yield SHAPE_CEILING_Z;
                    }
                }
                yield SHAPE_CEILING_X;
            }
            case Attachment.WALL -> {
                switch ((class_2350)state.method_11654((class_2769)FACING)) {
                    case field_11035: {
                        yield SHAPE_SOUTH;
                    }
                    case field_11034: {
                        yield SHAPE_EAST;
                    }
                    case field_11039: {
                        yield SHAPE_WEST;
                    }
                }
                yield SHAPE_NORTH;
            }
            case Attachment.CENTER_UPRIGHT -> {
                switch ((class_2350)state.method_11654((class_2769)FACING)) {
                    case field_11043: 
                    case field_11035: {
                        yield SHAPE_X;
                    }
                }
                yield SHAPE_Z;
            }
        };
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new StoneTabletBlockEntity(pos, state);
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof StoneTabletBlockEntity) {
            StoneTabletBlockEntity tile = (StoneTabletBlockEntity)class_25862;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (this.clear(level, pos, serverPlayer, hand)) {
                    return class_1269.field_5812;
                }
                if (this.openTextEdit(serverPlayer, tile)) {
                    return class_1269.field_5812;
                }
                return class_1269.field_5811;
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    private boolean clear(class_1937 level, class_2338 pos, class_3222 player, class_1268 hand) {
        class_1799 held = player.method_5998(hand);
        class_2680 state = level.method_8320(pos);
        if (!held.method_31573(class_3489.field_42614)) {
            return false;
        }
        if (this.type != Type.ENGRAVED) {
            return false;
        }
        RegSupplier<class_2248> tablet = level.field_9229.method_43048(5) == 0 ? DGBlocks.CRACKED_STONE_TABLET : DGBlocks.STONE_TABLET;
        level.method_8501(pos, ((class_2248)tablet.get()).method_34725(state));
        held.method_7956(1, (class_1309)player, it -> it.method_20236(hand));
        return true;
    }

    private boolean hasEditableText(class_1657 player, StoneTabletBlockEntity signEntity) {
        StoneTabletText signText = signEntity.getText();
        return Arrays.stream(signText.getMessages(player.method_33793())).allMatch(p -> p.equals(class_5244.field_39003) || p.method_10851() instanceof class_2585);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof StoneTabletBlockEntity) {
            StoneTabletBlockEntity tile = (StoneTabletBlockEntity)class_25862;
            class_1799 stack = this.method_8389().method_7854();
            class_2487 tag = new class_2487();
            tag.method_10566("BlockEntityTag", (class_2520)tile.method_38244());
            class_2487 stateTag = new class_2487();
            tag.method_10566("BlockStateTag", (class_2520)stateTag);
            stack.method_7980(tag);
            return stack;
        }
        return super.method_9574(level, pos, state);
    }

    public boolean openTextEdit(class_3222 player, StoneTabletBlockEntity blockEntity) {
        if (this.otherPlayerIsEditingSign((class_1657)player, blockEntity)) {
            return false;
        }
        if (!player.method_7294()) {
            return false;
        }
        if (!this.hasEditableText((class_1657)player, blockEntity)) {
            return false;
        }
        blockEntity.setAllowedPlayerEditor(player.method_5667());
        DGNetwork.CHANNEL.sendToClientPlayer(player, (Message)new EngraveStoneTabletPacket(blockEntity.method_11016()));
        return true;
    }

    private boolean otherPlayerIsEditingSign(class_1657 player, StoneTabletBlockEntity signEntity) {
        UUID id = signEntity.getPlayerWhoMayEdit();
        return id != null && !id.equals(player.method_5667());
    }

    @Override
    public class_2591<StoneTabletBlockEntity> getType() {
        return (class_2591)DGBlockEntities.STONE_TABLET.get();
    }

    public static enum Type implements class_3542
    {
        DEFAULT,
        ENGRAVED,
        CRACKED;


        public String method_15434() {
            return this.name().toLowerCase();
        }
    }

    public static enum Attachment implements class_3542
    {
        CENTER_UPRIGHT,
        WALL,
        CEILING,
        FLOOR;


        public String method_15434() {
            return this.name().toLowerCase();
        }

        public boolean isUpright() {
            return this == CENTER_UPRIGHT || this == WALL;
        }
    }
}

