/*
 * Decompiled with CFR 0.152.
 */
package galena.doom_and_gloom.content.block;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import galena.doom_and_gloom.DoomAndGloom;
import galena.doom_and_gloom.content.block.StoneTabletBlock;
import galena.doom_and_gloom.content.block.StoneTabletText;
import galena.doom_and_gloom.content.entity.Ticking;
import galena.doom_and_gloom.index.DGBlockEntities;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5837;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class StoneTabletBlockEntity
extends class_2586
implements Ticking {
    private static final int MAX_TEXT_LINE_WIDTH = 120;
    private static final int TEXT_LINE_HEIGHT = 10;
    @Nullable
    private UUID playerWhoMayEdit;
    private StoneTabletText frontText = new StoneTabletText();
    public final StoneTabletBlock.Type type;

    public StoneTabletBlockEntity(class_2338 pos, class_2680 blockState) {
        super((class_2591)DGBlockEntities.STONE_TABLET.get(), pos, blockState);
        this.type = ((StoneTabletBlock)blockState.method_26204()).type;
    }

    public StoneTabletText getText() {
        return this.frontText;
    }

    public int getTextLineHeight() {
        return 10;
    }

    public int getMaxTextLineWidth() {
        return 120;
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        StoneTabletText.DIRECT_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.frontText).resultOrPartial(arg_0 -> ((Logger)DoomAndGloom.LOGGER).error(arg_0)).ifPresent(tagx -> tag.method_10566("front_text", tagx));
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545("text")) {
            StoneTabletText.DIRECT_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10562("text")).resultOrPartial(arg_0 -> ((Logger)DoomAndGloom.LOGGER).error(arg_0)).ifPresent(signText -> {
                this.frontText = this.loadLines((StoneTabletText)signText);
            });
        }
    }

    private StoneTabletText loadLines(StoneTabletText text) {
        for (int i = 0; i < text.getLineCount(); ++i) {
            class_2561 notFiltered = this.loadLine(text.getMessage(i, false));
            class_2561 filtered = this.loadLine(text.getMessage(i, true));
            text = text.withMessage(i, notFiltered, filtered);
        }
        return text;
    }

    private class_2561 loadLine(class_2561 lineText) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            try {
                return class_2564.method_10881((class_2168)StoneTabletBlockEntity.createCommandSourceStack(null, (class_1937)serverLevel, this.field_11867), (class_2561)lineText, null, (int)0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return lineText;
    }

    public void updateStoneTabletText(class_1657 player, List<class_5837> filteredText) {
        if (player.method_5667().equals(this.getPlayerWhoMayEdit()) && this.field_11863 != null) {
            this.updateText(signText -> this.setMessages(player, filteredText, (StoneTabletText)signText));
            this.setAllowedPlayerEditor(null);
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        } else {
            DoomAndGloom.LOGGER.warn("Player {} just tried to change non-editable sign", (Object)player.method_5477().getString());
        }
    }

    public boolean updateText(UnaryOperator<StoneTabletText> updater) {
        StoneTabletText signText = this.getText();
        return this.setText((StoneTabletText)updater.apply(signText));
    }

    private StoneTabletText setMessages(class_1657 player, List<class_5837> filteredText, StoneTabletText text) {
        for (int i = 0; i < filteredText.size(); ++i) {
            class_5837 filteredText2 = filteredText.get(i);
            class_2583 style = text.getMessage(i, player.method_33793()).method_10866();
            text = player.method_33793() ? text.withMessage(i, (class_2561)class_2561.method_43470((String)filteredText2.method_45061()).method_10862(style)) : text.withMessage(i, (class_2561)class_2561.method_43470((String)filteredText2.comp_841()).method_10862(style), (class_2561)class_2561.method_43470((String)filteredText2.method_45061()).method_10862(style));
        }
        return text;
    }

    public boolean setText(StoneTabletText text) {
        if (text != this.frontText) {
            this.frontText = text;
            this.markUpdated();
            return true;
        }
        return false;
    }

    public static class_2168 createCommandSourceStack(@Nullable class_1657 player, class_1937 level, class_2338 pos) {
        String string = player == null ? "Sign" : player.method_5477().getString();
        class_5250 component = player == null ? class_2561.method_43470((String)"Sign") : player.method_5476();
        return new class_2168(class_2165.field_17395, class_243.method_24953((class_2382)pos), class_241.field_1340, (class_3218)level, 2, string, (class_2561)component, level.method_8503(), (class_1297)player);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public boolean method_11011() {
        return true;
    }

    public void setAllowedPlayerEditor(@Nullable UUID playWhoMayEdit) {
        this.playerWhoMayEdit = playWhoMayEdit;
    }

    @Nullable
    public UUID getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    private void markUpdated() {
        this.method_5431();
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public boolean playerIsTooFarAwayToEdit(UUID uuid) {
        class_1657 player = this.field_11863.method_18470(uuid);
        return player == null || player.method_5649((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) > 64.0;
    }

    @Override
    public void tick(class_2680 state, class_1937 level, class_2338 pos) {
        UUID uUID = this.getPlayerWhoMayEdit();
        if (uUID != null) {
            this.clearInvalidPlayerWhoMayEdit(level, uUID);
        }
    }

    private void clearInvalidPlayerWhoMayEdit(class_1937 level, UUID uuid) {
        if (this.playerIsTooFarAwayToEdit(uuid)) {
            this.setAllowedPlayerEditor(null);
        }
    }
}

