/*
 * Decompiled with CFR 0.152.
 */
package galena.doom_and_gloom.content.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5244;
import net.minecraft.class_5481;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;

public class StoneTabletText {
    public static final int LINES = 13;
    private static final Codec<class_2561[]> LINES_CODEC = class_5699.field_43173.listOf().comapFlatMap(list -> class_156.method_33141((List)list, (int)13).map(listx -> listx.toArray(new class_2561[0])), Arrays::asList);
    public static final Codec<StoneTabletText> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LINES_CODEC.fieldOf("messages").forGetter(signText -> signText.messages), (App)LINES_CODEC.optionalFieldOf("filtered_messages").forGetter(StoneTabletText::getOnlyFilteredMessages)).apply((Applicative)instance, StoneTabletText::load));
    private final class_2561[] messages;
    private final class_2561[] filteredMessages;
    @Nullable
    private class_5481[] renderMessages;
    private boolean renderMessagedFiltered;

    public StoneTabletText() {
        this(StoneTabletText.emptyMessages(), StoneTabletText.emptyMessages());
    }

    public StoneTabletText(class_2561[] messages, class_2561[] filteredMessages) {
        this.messages = messages;
        this.filteredMessages = filteredMessages;
    }

    public int getLineCount() {
        return this.messages.length;
    }

    private static class_2561[] emptyMessages() {
        Object[] components = new class_2561[13];
        Arrays.fill(components, class_5244.field_39003);
        return components;
    }

    private static StoneTabletText load(class_2561[] messages, Optional<class_2561[]> filteredMessages) {
        class_2561[] components = filteredMessages.orElseGet(StoneTabletText::emptyMessages);
        StoneTabletText.populateFilteredMessagesWithRawMessages(messages, components);
        return new StoneTabletText(messages, components);
    }

    private static void populateFilteredMessagesWithRawMessages(class_2561[] messages, class_2561[] filteredMessages) {
        for (int i = 0; i < 13; ++i) {
            if (!filteredMessages[i].equals(class_5244.field_39003)) continue;
            filteredMessages[i] = messages[i];
        }
    }

    public class_2561 getMessage(int index, boolean isFiltered) {
        return this.getMessages(isFiltered)[index];
    }

    public StoneTabletText withMessage(int index, class_2561 text) {
        return this.withMessage(index, text, text);
    }

    public StoneTabletText withMessage(int index, class_2561 text, class_2561 filteredText) {
        class_2561[] components = Arrays.copyOf(this.messages, this.messages.length);
        class_2561[] components2 = Arrays.copyOf(this.filteredMessages, this.filteredMessages.length);
        components[index] = text;
        components2[index] = filteredText;
        return new StoneTabletText(components, components2);
    }

    public boolean hasMessage(class_1657 player) {
        return Arrays.stream(this.getMessages(player.method_33793())).anyMatch(component -> !component.getString().isEmpty());
    }

    public class_2561[] getMessages(boolean isFiltered) {
        return isFiltered ? this.filteredMessages : this.messages;
    }

    public class_5481[] getRenderMessages(boolean renderMessagesFiltered, Function<class_2561, class_5481> formatter) {
        if (this.renderMessages == null || this.renderMessagedFiltered != renderMessagesFiltered) {
            this.renderMessagedFiltered = renderMessagesFiltered;
            this.renderMessages = new class_5481[13];
            for (int i = 0; i < 13; ++i) {
                this.renderMessages[i] = formatter.apply(this.getMessage(i, renderMessagesFiltered));
            }
        }
        return this.renderMessages;
    }

    private Optional<class_2561[]> getOnlyFilteredMessages() {
        class_2561[] components = new class_2561[13];
        boolean bl = false;
        for (int i = 0; i < 13; ++i) {
            class_2561 component = this.filteredMessages[i];
            if (!component.equals(this.messages[i])) {
                components[i] = component;
                bl = true;
                continue;
            }
            components[i] = class_5244.field_39003;
        }
        return bl ? Optional.of(components) : Optional.empty();
    }

    public boolean hasAnyClickCommands(class_1657 player) {
        for (class_2561 component : this.getMessages(player.method_33793())) {
            class_2583 style = component.method_10866();
            class_2558 clickEvent = style.method_10970();
            if (clickEvent == null || clickEvent.method_10845() != class_2558.class_2559.field_11750) continue;
            return true;
        }
        return false;
    }
}

