/*
 * Decompiled with CFR 0.152.
 */
package galena.doom_and_gloom.content.entity;

import galena.doom_and_gloom.DGConfig;
import galena.doom_and_gloom.content.block.SepulcherBlock;
import galena.doom_and_gloom.content.entity.ISepulcherable;
import galena.doom_and_gloom.content.entity.Ticking;
import galena.doom_and_gloom.index.DGBlockEntities;
import galena.doom_and_gloom.index.DGBlocks;
import galena.doom_and_gloom.index.DGSoundEvents;
import galena.doom_and_gloom.index.DGTags;
import galena.doom_and_gloom.network.DGNetwork;
import galena.doom_and_gloom.network.packet.SepulcherConsumesDeathPacket;
import galena.doom_and_gloom.network.packet.SepulcherRotsPacket;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4050;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;

public class SepulcherBlockEntity
extends class_2586
implements Ticking,
class_1263,
class_5714.class_8513<DeathListener> {
    private final DeathListener listener = new DeathListener();
    private int progress = 0;
    private boolean heated = false;

    public SepulcherBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)DGBlockEntities.SEPULCHER.get(), pos, state);
    }

    private int progressNeeded(int fillLevel) {
        if (fillLevel == 13) {
            return 20;
        }
        return DGConfig.COMMON.sepulcherDuration.get() / 4;
    }

    @Override
    public void tick(class_2680 state, class_1937 level, class_2338 pos) {
        int fillLevel = (Integer)state.method_11654((class_2769)SepulcherBlock.LEVEL);
        if (fillLevel < 13) {
            return;
        }
        if (fillLevel == 18) {
            return;
        }
        if (level.method_8510() % 20L == 0L) {
            this.checkHeatSource(level, pos);
        }
        int step = this.heated ? 3 : 1;
        this.progress += step;
        if (this.progress < this.progressNeeded(fillLevel)) {
            return;
        }
        int nextLevel = fillLevel + 1;
        level.method_8501(pos, (class_2680)state.method_11657((class_2769)SepulcherBlock.LEVEL, (Comparable)Integer.valueOf(nextLevel)));
        this.progress = 0;
        if (fillLevel == 13) {
            this.sound((Supplier<? extends class_3414>)DGSoundEvents.SEPULCHER_SEALING, 1.0f);
        } else if (nextLevel == 18) {
            this.sound((Supplier<? extends class_3414>)DGSoundEvents.SEPULCHER_UNSEALING, 1.0f);
        } else {
            this.sound((Supplier<? extends class_3414>)DGSoundEvents.SEPULCHER_ROTTING, 0.5f);
        }
        if (!level.method_8608()) {
            DGNetwork.CHANNEL.sendToAllClientPlayersInRange(level, pos, 16.0, (Message)new SepulcherRotsPacket(pos));
        }
    }

    private void sound(Supplier<? extends class_3414> sound, float volume) {
        if (!this.method_11002()) {
            return;
        }
        this.field_11863.method_8396(null, this.method_11016(), sound.get(), class_3419.field_15245, volume, 1.0f);
    }

    private void checkHeatSource(class_1937 level, class_2338 pos) {
        class_2338 below = pos.method_10074();
        class_2680 belowState = level.method_8320(below);
        this.heated = belowState.method_26164(DGTags.Blocks.HEAT_SOURCE);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("progress", this.progress);
        nbt.method_10556("heated", this.heated);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.progress = nbt.method_10550("progress");
        this.heated = nbt.method_10577("heated");
    }

    public DeathListener getListener() {
        return this.listener;
    }

    public int method_5439() {
        return 1;
    }

    public boolean method_5442() {
        Integer fillLevel = (Integer)this.method_11010().method_11654((class_2769)SepulcherBlock.LEVEL);
        return fillLevel < 18;
    }

    public class_1799 method_5438(int slot) {
        Integer fillLevel = (Integer)this.method_11010().method_11654((class_2769)SepulcherBlock.LEVEL);
        if (fillLevel == 18) {
            return new class_1799((class_1935)DGBlocks.BONE_PILE.get());
        }
        return class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int count) {
        class_1799 stack = this.method_5438(slot);
        if (!stack.method_7960()) {
            SepulcherBlock.clear(null, this.method_11010(), this.method_10997(), this.method_11016());
        }
        return stack;
    }

    public class_1799 method_5441(int slot) {
        return this.method_5434(slot, 1);
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return SepulcherBlock.tryInsert(stack, null, this.method_11010(), this.method_10997(), this.method_11016(), true);
    }

    public boolean method_49104(class_1263 container, int slot, class_1799 stack) {
        return (Integer)this.method_11010().method_11654((class_2769)SepulcherBlock.LEVEL) == 18;
    }

    public void method_5447(int slot, class_1799 stack) {
        SepulcherBlock.tryInsert(stack, null, this.method_11010(), this.method_10997(), this.method_11016(), false);
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        SepulcherBlock.clear(null, this.method_11010(), this.method_10997(), this.method_11016());
    }

    public class DeathListener
    implements class_5714 {
        private final class_5716 listenerSource;
        private final int listenerRadius;

        public DeathListener() {
            this.listenerSource = new class_5707(SepulcherBlockEntity.this.method_11016());
            this.listenerRadius = 3;
        }

        public class_5716 method_32946() {
            return this.listenerSource;
        }

        public int method_32948() {
            return this.listenerRadius;
        }

        public boolean method_32947(class_3218 level, class_5712 event, class_5712.class_7397 context, class_243 vec) {
            if (event != class_5712.field_37676) {
                return false;
            }
            class_1297 entity = context.comp_713();
            if (!(entity instanceof class_1309)) {
                return false;
            }
            class_1309 living = (class_1309)entity;
            ISepulcherable sepulchered = ISepulcherable.cast(living);
            if (sepulchered.DG$wasSepulchered()) {
                return false;
            }
            if (!entity.method_5864().method_20210(DGTags.Entities.FILLS_SEPULCHER)) {
                return false;
            }
            class_2680 state = SepulcherBlockEntity.this.method_11010();
            int fillLevel = (Integer)state.method_11654((class_2769)SepulcherBlock.LEVEL);
            if (fillLevel >= 13) {
                return false;
            }
            sepulchered.DG$setSepulchered(true);
            if (!(entity instanceof class_1657)) {
                living.method_41329();
            }
            SepulcherBlock.insert(null, state, (class_1937)level, SepulcherBlockEntity.this.method_11016(), level.field_9229.method_39332(3, 4));
            SepulcherBlockEntity.this.sound((Supplier<? extends class_3414>)DGSoundEvents.SEPULCHER_CORPSE_STUFFED, 1.0f);
            DGNetwork.CHANNEL.sendToAllClientPlayersInRange(entity.method_37908(), class_2338.method_49638((class_2374)vec), 16.0, (Message)new SepulcherConsumesDeathPacket(vec));
            entity.method_33574(class_243.method_24953((class_2382)SepulcherBlockEntity.this.method_11016()));
            if (entity.method_18376() == class_4050.field_18082) {
                entity.method_18380(class_4050.field_18076);
            }
            return true;
        }
    }
}

