/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.api;

import java.util.Random;

public class AudioEffect {
    private float pitchFactor = 1.0f;
    private float reverbDecay = 0.0f;
    private int reverbDelayMs = 0;
    private int reverbRepeats = 0;
    private boolean pitchEnabled = false;
    private boolean reverbEnabled = false;
    private static final int SAMPLE_RATE = 48000;
    private boolean robotEnabled;
    private float robotLfoFreq;

    public static AudioEffect pitch(float pitchFactor) {
        return new AudioEffect().changePitch(pitchFactor);
    }

    public AudioEffect changePitch(float pitchFactor) {
        this.pitchFactor = pitchFactor;
        this.pitchEnabled = true;
        return this;
    }

    public static AudioEffect reverb(float decay, int delayMs, int repeats) {
        return new AudioEffect().makeReverb(decay, delayMs, repeats);
    }

    public AudioEffect makeReverb(float decay, int delayMs, int repeats) {
        this.reverbDecay = decay;
        this.reverbDelayMs = delayMs;
        this.reverbRepeats = repeats;
        this.reverbEnabled = true;
        return this;
    }

    public static AudioEffect robot(float lfoFreqhz) {
        return new AudioEffect().makeRobot(lfoFreqhz);
    }

    public AudioEffect makeRobot(float lfoFreqHz) {
        this.robotEnabled = true;
        this.robotLfoFreq = lfoFreqHz;
        return this;
    }

    public static AudioEffect random() {
        return new AudioEffect().addRandomEffects();
    }

    public AudioEffect addRandomEffects() {
        Random random = new Random();
        boolean added = false;
        if (random.nextBoolean()) {
            this.changePitch(0.7f);
            added = true;
        }
        if (random.nextBoolean()) {
            this.makeReverb(0.5f, 160, 2);
            added = true;
        }
        if (random.nextBoolean()) {
            this.makeRobot(30.0f);
            added = true;
        }
        if (!added) {
            int forced = random.nextInt(3);
            switch (forced) {
                case 0: {
                    this.changePitch(0.7f);
                    break;
                }
                case 1: {
                    this.makeReverb(0.5f, 160, 2);
                    break;
                }
                case 2: {
                    this.makeRobot(30.0f);
                }
            }
        }
        return this;
    }

    public short[] applyEffects(short[] pcm) {
        if (this.pitchEnabled) {
            pcm = AudioEffect.changePitch(pcm, this.pitchFactor);
        }
        if (this.reverbEnabled) {
            pcm = AudioEffect.addReverb(pcm, this.reverbDecay, this.reverbDelayMs, this.reverbRepeats);
        }
        if (this.robotEnabled) {
            pcm = AudioEffect.robotize(pcm, this.robotLfoFreq);
        }
        return pcm;
    }

    private static short[] changePitch(short[] pcm, float pitchFactor) {
        if (pitchFactor <= 0.0f) {
            throw new IllegalArgumentException("Pitch factor must be > 0");
        }
        int newLength = (int)((float)pcm.length / pitchFactor);
        short[] result = new short[newLength];
        for (int i = 0; i < newLength; ++i) {
            float srcIndex = (float)i * pitchFactor;
            int index = (int)srcIndex;
            float frac = srcIndex - (float)index;
            result[i] = index + 1 < pcm.length ? (short)((1.0f - frac) * (float)pcm[index] + frac * (float)pcm[index + 1]) : pcm[index];
        }
        return result;
    }

    private static short[] addReverb(short[] input, float decay, int delayMs, int repeats) {
        if (decay <= 0.0f || decay >= 1.0f) {
            throw new IllegalArgumentException("Decay must be between 0 and 1");
        }
        if (delayMs <= 0 || repeats <= 0) {
            throw new IllegalArgumentException("Delay and repeats must be > 0");
        }
        int delaySamples = 48000 * delayMs / 1000;
        int totalLength = input.length + delaySamples * repeats;
        short[] output = new short[totalLength];
        System.arraycopy(input, 0, output, 0, input.length);
        for (int r = 1; r <= repeats; ++r) {
            int delayedIndex;
            int offset = delaySamples * r;
            float currentDecay = (float)Math.pow(decay, r);
            for (int i = 0; i < input.length && (delayedIndex = i + offset) < output.length; ++i) {
                int mixed = output[delayedIndex] + (int)((float)input[i] * currentDecay);
                output[delayedIndex] = (short)Math.max(Math.min(mixed, Short.MAX_VALUE), Short.MIN_VALUE);
            }
        }
        return output;
    }

    private static short[] robotize(short[] pcm, float lfoFreqHz) {
        if (lfoFreqHz <= 0.0f) {
            throw new IllegalArgumentException("LFO frequency must be > 0");
        }
        short[] output = new short[pcm.length];
        double lfoPhase = 0.0;
        double lfoIncrement = Math.PI * 2 * (double)lfoFreqHz / 48000.0;
        for (int i = 0; i < pcm.length; ++i) {
            int sample;
            double modulator = Math.cos(lfoPhase);
            if ((lfoPhase += lfoIncrement) >= Math.PI * 2) {
                lfoPhase -= Math.PI * 2;
            }
            if ((sample = (int)((double)pcm[i] * modulator)) > Short.MAX_VALUE) {
                sample = Short.MAX_VALUE;
            } else if (sample < Short.MIN_VALUE) {
                sample = Short.MIN_VALUE;
            }
            output[i] = (short)sample;
        }
        return output;
    }
}

