/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.api.util;

import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.EntityAudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.api.AudioEffect;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import dev.omialien.voicechatrecording.voicechat.audio.AudioPlayer;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class AudioPlayingUtil {
    public static void playLocationalAudio(IRecordedAudio audio, Vec3 position, ServerLevel level, String category) {
        AudioPlayingUtil.playLocationalAudio(audio, position, level, null, category, 32.0f);
    }

    public static void playLocationalAudio(IRecordedAudio audio, Vec3 position, ServerLevel level, AudioEffect effects, String category, float distance) {
        if (audio == null) {
            return;
        }
        LocationalAudioChannel chan = VoiceChatRecording.vcApi.createLocationalAudioChannel(UUID.randomUUID(), VoiceChatRecording.vcApi.fromServerLevel((Object)level), VoiceChatRecording.vcApi.createPosition(position.x, position.y, position.z));
        if (chan == null) {
            VoiceChatRecording.LOGGER.error("Couldn't create audio channel for {}", (Object)position);
            return;
        }
        chan.setDistance(distance);
        chan.setCategory(category);
        AudioPlayingUtil.play(audio.applyEffects(effects), (AudioChannel)chan, VoiceChatRecording.vcApi);
    }

    public static void playFromEntity(IRecordedAudio audio, Entity entity, String category) {
        AudioPlayingUtil.playFromEntity(audio, entity, null, category, 32.0f);
    }

    public static void playFromEntity(IRecordedAudio audio, Entity entity, AudioEffect effects, String category, float distance) {
        if (audio == null) {
            return;
        }
        VoicechatServerApi api = VoiceChatRecording.vcApi;
        EntityAudioChannel chan = api.createEntityAudioChannel(UUID.randomUUID(), api.fromEntity((Object)entity));
        if (chan == null) {
            VoiceChatRecording.LOGGER.error("Couldn't create audio channel for {}", (Object)entity.getName());
            return;
        }
        chan.setCategory(category);
        chan.setDistance(distance);
        AudioPlayingUtil.play(audio.applyEffects(effects), (AudioChannel)chan, api);
    }

    private static void play(short[] audio, AudioChannel chan, VoicechatServerApi api) {
        new AudioPlayer(audio, api, chan).start();
    }
}

