/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.omialien.voicechatrecording.commands.CommandUtil;
import dev.omialien.voicechatrecording.voicechat.RecordedAudio;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;

public class AudioInfoCommand {
    public static final int PERMISSION_LEVEL = 2;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"audioInfo").requires(src -> src.hasPermission(2))).then(CommandUtil.PLAYER_ARGUMENT.then(CommandUtil.AUDIO_ARGUMENT.executes(AudioInfoCommand::executeCommand))));
    }

    private static int executeCommand(CommandContext<CommandSourceStack> src) {
        UUID player = UuidArgument.getUuid(src, (String)"player");
        UUID id = UuidArgument.getUuid(src, (String)"audio");
        CommandUtil.loadAudio(player, id, src, res -> {
            if (res != null) {
                String info = ((RecordedAudio)res).getAudioInfo();
                ((CommandSourceStack)src.getSource()).sendSuccess(() -> Component.literal((String)info), false);
            } else {
                ((CommandSourceStack)src.getSource()).sendFailure((Component)Component.literal((String)("Audio " + String.valueOf(id) + " not found")));
            }
        });
        return 0;
    }
}

