/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import dev.omialien.voicechatrecording.voicechat.VoiceChatRecordingPlugin;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;

public class CommandUtil {
    public static RequiredArgumentBuilder<CommandSourceStack, UUID> PLAYER_ARGUMENT = Commands.argument((String)"player", (ArgumentType)UuidArgument.uuid()).suggests((src, suggestionsBuilder) -> SharedSuggestionProvider.suggest(CommandUtil.getAllSavedAudios().map(p -> ((UUID)p.getFirst()).toString()), (SuggestionsBuilder)suggestionsBuilder));
    public static RequiredArgumentBuilder<CommandSourceStack, UUID> AUDIO_ARGUMENT = Commands.argument((String)"audio", (ArgumentType)UuidArgument.uuid()).suggests((src, suggestionsBuilder) -> SharedSuggestionProvider.suggest(CommandUtil.getAllSavedAudios().map(p -> ((UUID)p.getSecond()).toString()), (SuggestionsBuilder)suggestionsBuilder));

    public static Stream<Pair<UUID, UUID>> getAllSavedAudios() {
        return ((VoiceChatRecordingPlugin)VoiceChatRecording.recordingApi).savedAudios.values().stream().flatMap(Collection::stream);
    }

    public static Stream<IRecordedAudio> getRememberedAudios() {
        return VoiceChatRecording.storedAudios.stream();
    }

    public static void sendInterruptFailure(CommandSourceStack src) {
        src.sendFailure((Component)Component.literal((String)"Audio loading was interrupted!"));
    }

    public static void sendLoadFailure(CommandSourceStack src) {
        src.sendFailure((Component)Component.literal((String)"There was an error during audio loading!"));
    }

    public static void loadAudio(UUID player, UUID id, CommandContext<CommandSourceStack> src, Consumer<IRecordedAudio> reaction) {
        try {
            VoiceChatRecording.recordingApi.loadAudio(player, id, reaction).get();
        }
        catch (InterruptedException e) {
            CommandUtil.sendInterruptFailure((CommandSourceStack)src.getSource());
        }
        catch (ExecutionException e) {
            CommandUtil.sendLoadFailure((CommandSourceStack)src.getSource());
        }
    }
}

