/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.PlayerList;

public class IsRecordingCommand {
    public static final int PERMISSION_LEVEL = 2;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"isRecording").requires(cmdSrc -> cmdSrc.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).suggests((cmdSrc, suggestionsBuilder) -> {
            PlayerList playerlist = ((CommandSourceStack)cmdSrc.getSource()).getServer().getPlayerList();
            return SharedSuggestionProvider.suggest(playerlist.getPlayers().stream().map(player -> player.getGameProfile().getName()), (SuggestionsBuilder)suggestionsBuilder);
        }).executes(cmdSrc -> {
            StringBuilder sb = new StringBuilder();
            Collection targets = GameProfileArgument.getGameProfiles((CommandContext)cmdSrc, (String)"targets");
            for (GameProfile target : targets) {
                sb.append(target.getName()).append(": ").append(VoiceChatRecording.recordingApi.getRecordedPlayer(target.getId()).isRecording());
                if (targets.size() == 1) continue;
                sb.append("\n");
            }
            VoiceChatRecording.LOGGER.debug(sb.toString());
            ((CommandSourceStack)cmdSrc.getSource()).sendSuccess(() -> Component.literal((String)sb.toString()), false);
            return 1;
        })));
    }
}

