/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.api.AudioEffect;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import dev.omialien.voicechatrecording.api.util.AudioPlayingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NearestEntityPlayVoiceCommand {
    public static final int PERMISSION_LEVEL = 2;
    private static final float CHANNEL_DISTANCE = 20.0f;
    public static final int bbX = 5;
    public static final int bbY = 5;
    public static final int bbZ = 5;

    private static LiteralArgumentBuilder<CommandSourceStack> PITCH_ARG(Command<CommandSourceStack> cmd) {
        return (LiteralArgumentBuilder)Commands.literal((String)"pitch").then(Commands.argument((String)"pitchFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(cmd));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> REVERB_ARG(Command<CommandSourceStack> cmd) {
        return (LiteralArgumentBuilder)Commands.literal((String)"reverb").then(Commands.argument((String)"decay", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.argument((String)"delay-ms", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"repeats", (ArgumentType)IntegerArgumentType.integer()).executes(cmd))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> ROBOT_ARG(Command<CommandSourceStack> cmd) {
        return (LiteralArgumentBuilder)Commands.literal((String)"robot").then(Commands.argument((String)"lfo-frequency", (ArgumentType)FloatArgumentType.floatArg()).executes(cmd));
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"playVoice").requires(src -> src.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"uuid", (ArgumentType)UuidArgument.uuid()).suggests((src, suggestionsBuilder) -> SharedSuggestionProvider.suggest(VoiceChatRecording.storedAudios.stream().map(r -> r.getId().toString()), (SuggestionsBuilder)suggestionsBuilder)).executes(ctx -> {
            VoiceChatRecording.LOGGER.debug("id");
            return NearestEntityPlayVoiceCommand.runCommand((CommandContext<CommandSourceStack>)ctx, null, UuidArgument.getUuid((CommandContext)ctx, (String)"uuid"), null);
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)EntityArgument.entities()).executes(ctx -> {
            VoiceChatRecording.LOGGER.debug("ent id");
            return NearestEntityPlayVoiceCommand.runCommand((CommandContext<CommandSourceStack>)ctx, EntityArgument.getEntities((CommandContext)ctx, (String)"entity"), UuidArgument.getUuid((CommandContext)ctx, (String)"uuid"), null);
        })).then(NearestEntityPlayVoiceCommand.PITCH_ARG((Command<CommandSourceStack>)((Command)ctx -> {
            VoiceChatRecording.LOGGER.debug("ent id pitch");
            return NearestEntityPlayVoiceCommand.runCommand((CommandContext<CommandSourceStack>)ctx, EntityArgument.getEntities((CommandContext)ctx, (String)"entity"), UuidArgument.getUuid((CommandContext)ctx, (String)"uuid"), AudioEffect.pitch(FloatArgumentType.getFloat((CommandContext)ctx, (String)"pitchFactor")));
        })))).then(NearestEntityPlayVoiceCommand.REVERB_ARG((Command<CommandSourceStack>)((Command)ctx -> {
            VoiceChatRecording.LOGGER.debug("ent id reverb");
            float decay = FloatArgumentType.getFloat((CommandContext)ctx, (String)"decay");
            int delay = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"delay-ms");
            int repeats = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"repeats");
            return NearestEntityPlayVoiceCommand.runCommand((CommandContext<CommandSourceStack>)ctx, EntityArgument.getEntities((CommandContext)ctx, (String)"entity"), UuidArgument.getUuid((CommandContext)ctx, (String)"uuid"), AudioEffect.reverb(decay, delay, repeats));
        })))).then(NearestEntityPlayVoiceCommand.ROBOT_ARG((Command<CommandSourceStack>)((Command)ctx -> {
            VoiceChatRecording.LOGGER.debug("ent id robot");
            return NearestEntityPlayVoiceCommand.runCommand((CommandContext<CommandSourceStack>)ctx, EntityArgument.getEntities((CommandContext)ctx, (String)"entity"), UuidArgument.getUuid((CommandContext)ctx, (String)"uuid"), AudioEffect.robot(FloatArgumentType.getFloat((CommandContext)ctx, (String)"lfo-frequency")));
        })))).then(Commands.literal((String)"random").executes(ctx -> {
            VoiceChatRecording.LOGGER.debug("ent id random");
            return NearestEntityPlayVoiceCommand.runCommand((CommandContext<CommandSourceStack>)ctx, EntityArgument.getEntities((CommandContext)ctx, (String)"entity"), UuidArgument.getUuid((CommandContext)ctx, (String)"uuid"), AudioEffect.random());
        })))));
    }

    private static LivingEntity getNearestEntity(CommandContext<CommandSourceStack> ctx) {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        Vec3 srcPos = ((CommandSourceStack)ctx.getSource()).getPosition();
        AABB aabb = new AABB(srcPos.x + 5.0, srcPos.y + 5.0, srcPos.z + 5.0, srcPos.x - 5.0, srcPos.y - 5.0, srcPos.z - 5.0);
        return level.getNearestEntity(LivingEntity.class, TargetingConditions.DEFAULT, null, srcPos.x, srcPos.y, srcPos.z, aabb);
    }

    private static void playAudio(CommandContext<CommandSourceStack> ctx, Entity entity, UUID id, AudioEffect effects) {
        VoiceChatRecording.LOGGER.debug("Entity: " + String.valueOf(entity.getName()));
        IRecordedAudio audio = null;
        for (IRecordedAudio cur : VoiceChatRecording.storedAudios) {
            if (!cur.getId().equals(id)) continue;
            audio = cur;
            break;
        }
        if (audio != null) {
            Player player = entity.level().getPlayerByUUID(audio.getPlayerUUID());
            String playerName = player == null ? audio.getPlayerUUID().toString() : player.getName().getString();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Playing audio of " + playerName + " from ")).append(entity.getName()), true);
            AudioPlayingUtil.playFromEntity(audio, entity, effects, "recording_vc", 20.0f);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Invalid ID " + String.valueOf(id))));
        }
    }

    public static int runCommand(CommandContext<CommandSourceStack> ctx, @Nullable Collection<? extends Entity> targets, UUID id, AudioEffect effects) {
        try {
            List<Entity> entities;
            List<Entity> list = entities = targets == null ? null : targets.stream().map(e -> e).toList();
            if (entities == null) {
                LivingEntity nearestEntity = NearestEntityPlayVoiceCommand.getNearestEntity(ctx);
                if (nearestEntity == null) {
                    ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"No entity found!"));
                    return 20;
                }
                entities = new ArrayList<Entity>();
                entities.add((Entity)nearestEntity);
            }
            for (Entity audioTarget : entities) {
                NearestEntityPlayVoiceCommand.playAudio(ctx, audioTarget, id, effects);
            }
            return 0;
        }
        catch (Exception e2) {
            VoiceChatRecording.LOGGER.error("Error running playVoice: {}\r\n{}", (Object)e2.getMessage(), (Object)e2.getStackTrace());
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)e2.getMessage()));
            return 100;
        }
    }
}

