/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import dev.omialien.voicechatrecording.commands.CommandUtil;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class SaveAudioCommand {
    public static final int PERMISSION_LEVEL = 2;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"saveAudio").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)UuidArgument.uuid()).suggests((src, suggestionsBuilder) -> SharedSuggestionProvider.suggest(CommandUtil.getRememberedAudios().map(r -> r.getPlayerUUID().toString()), (SuggestionsBuilder)suggestionsBuilder)).then(Commands.argument((String)"audio", (ArgumentType)UuidArgument.uuid()).suggests((src, suggestionsBuilder) -> SharedSuggestionProvider.suggest(CommandUtil.getRememberedAudios().map(r -> r.getId().toString()), (SuggestionsBuilder)suggestionsBuilder)).executes(SaveAudioCommand::runCommand))));
    }

    private static int runCommand(CommandContext<CommandSourceStack> src) {
        UUID player = UuidArgument.getUuid(src, (String)"player");
        UUID audioId = UuidArgument.getUuid(src, (String)"audio");
        for (IRecordedAudio audio : VoiceChatRecording.storedAudios) {
            if (!audio.getPlayerUUID().equals(player) || !audio.getId().equals(audioId)) continue;
            boolean res = audio.saveAudio("voicechatrecording");
            if (res) {
                StringBuilder builder = new StringBuilder("Saved audio ");
                builder.append(audioId);
                builder.append(" by ");
                Player p = ((CommandSourceStack)src.getSource()).getLevel().getPlayerByUUID(player);
                builder.append(p == null ? player : p.getName().getString());
                ((CommandSourceStack)src.getSource()).sendSuccess(() -> Component.literal((String)builder.toString()), true);
            } else {
                ((CommandSourceStack)src.getSource()).sendFailure((Component)Component.literal((String)"Could not save audio!"));
                if (VoiceChatRecording.recordingApi.getPrivacy(player)) {
                    ((CommandSourceStack)src.getSource()).sendFailure((Component)Component.literal((String)"Player has privacy mode enabled"));
                } else {
                    ((CommandSourceStack)src.getSource()).sendFailure((Component)Component.literal((String)"Unknown reason"));
                }
            }
            return 0;
        }
        ((CommandSourceStack)src.getSource()).sendFailure((Component)Component.literal((String)"Audio not found"));
        return 1;
    }
}

