/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.events;

import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.configs.RecordingClientConfig;
import dev.omialien.voicechatrecording.networking.PrivacyModePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@Mod(value="voicechatrecording", dist={Dist.CLIENT})
@EventBusSubscriber(modid="voicechatrecording", value={Dist.CLIENT})
public class ClientEventBus {
    public ClientEventBus(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    private static void sendPrivacyPacket() {
        if (Minecraft.getInstance().getConnection() != null) {
            PrivacyModePacket packet = new PrivacyModePacket((Boolean)RecordingClientConfig.PRIVACY.get());
            VoiceChatRecording.LOGGER.debug("Sending privacy mode packet {}", (Object)packet.state());
            PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            VoiceChatRecording.LOGGER.debug("Tried to send packet without connection");
        }
    }

    @SubscribeEvent
    public static void onClientJoinLevel(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof LocalPlayer) {
            ClientEventBus.sendPrivacyPacket();
        }
    }

    @SubscribeEvent
    public static void onConfigChange(ModConfigEvent.Reloading e) {
        ClientEventBus.sendPrivacyPacket();
    }
}

