/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.events;

import com.mojang.brigadier.CommandDispatcher;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import dev.omialien.voicechatrecording.api.events.AudioEvent;
import dev.omialien.voicechatrecording.api.events.AudioLoadedEvent;
import dev.omialien.voicechatrecording.api.events.RecordingSetupEvent;
import dev.omialien.voicechatrecording.commands.AudioInfoCommand;
import dev.omialien.voicechatrecording.commands.IsRecordingCommand;
import dev.omialien.voicechatrecording.commands.ListAudiosCommand;
import dev.omialien.voicechatrecording.commands.LoadAudioCommand;
import dev.omialien.voicechatrecording.commands.NearestEntityPlayVoiceCommand;
import dev.omialien.voicechatrecording.commands.RememberAudiosCommand;
import dev.omialien.voicechatrecording.commands.SaveAudioCommand;
import dev.omialien.voicechatrecording.commands.ScheduleLogCommand;
import dev.omialien.voicechatrecording.commands.StartRecordingCommand;
import dev.omialien.voicechatrecording.commands.StopRecordingCommand;
import dev.omialien.voicechatrecording.networking.PrivacyModePacket;
import dev.omialien.voicechatrecording.networking.ServerPayloadHandler;
import dev.omialien.voicechatrecording.taskscheduler.TaskScheduler;
import dev.omialien.voicechatrecording.voicechat.RecordedAudio;
import dev.omialien.voicechatrecording.voicechat.VoiceChatRecordingPlugin;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="voicechatrecording")
public class CommonEventBus {
    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        VoiceChatRecording.storedAudios = new ArrayList<IRecordedAudio>();
        VoiceChatRecording.LOGGER.debug("Server starting");
        RecordedAudio.audiosPath = event.getServer().getWorldPath(VoiceChatRecording.AUDIO_DIRECTORY);
        if (!Files.exists(RecordedAudio.audiosPath, new LinkOption[0])) {
            try {
                Files.createDirectory(RecordedAudio.audiosPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                VoiceChatRecording.LOGGER.error("Error creating audios directory: " + e.getMessage());
            }
        }
    }

    @SubscribeEvent
    public static void onRecordingSetup(RecordingSetupEvent event) {
        event.addCategory("recording_vc", "Recording Plugin", "The volume of recorded voices", null);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onServerClosed(ServerStoppedEvent event) {
        try {
            VoiceChatRecording.LOGGER.info("Shutting down audio saving...");
            RememberAudiosCommand.shouldRemember = false;
            VoiceChatRecording.storedAudios.clear();
            ((VoiceChatRecordingPlugin)VoiceChatRecording.recordingApi).shutdownSaving();
            ((VoiceChatRecordingPlugin)VoiceChatRecording.recordingApi).shutdownAudioLoading();
        }
        catch (InterruptedException e) {
            VoiceChatRecording.LOGGER.error("Audio saving shutdown interrupted! {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
        }
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        NearestEntityPlayVoiceCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        StartRecordingCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        StopRecordingCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        IsRecordingCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ScheduleLogCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        RememberAudiosCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ListAudiosCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SaveAudioCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        AudioInfoCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        LoadAudioCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void tickEvent(ServerTickEvent.Post event) {
        VoiceChatRecording.TASKS.tick();
        TaskScheduler scheduler = ((VoiceChatRecordingPlugin)VoiceChatRecording.recordingApi).audioSavingTask;
        if (scheduler != null) {
            scheduler.tick();
        }
    }

    @SubscribeEvent
    public static void registerPayloads(RegisterPayloadHandlersEvent e) {
        PayloadRegistrar registrar = e.registrar("1");
        registrar.playToServer(PrivacyModePacket.TYPE, PrivacyModePacket.STREAM_CODEC, ServerPayloadHandler::handlePrivacy);
    }

    @SubscribeEvent
    public static void onLoadedAudio(AudioLoadedEvent event) {
        VoiceChatRecording.LOGGER.debug("EVENT: Audio loaded! {} {} {}", new Object[]{event.getAudio().getFilterResult(), event.getAudio().getPlayerUUID(), event.getAudio().getId()});
    }

    @SubscribeEvent
    public static void onGenericAudio(AudioEvent event) {
        IRecordedAudio.FilterResult filter;
        VoiceChatRecording.LOGGER.debug("GENERIC EVENT: audio {} {} {}", new Object[]{event.getAudio().getFilterResult().toString(), event.getAudio().getPlayerUUID(), event.getAudio().getId()});
        if (RememberAudiosCommand.shouldRemember && ((filter = event.getAudio().getFilterResult()) == IRecordedAudio.FilterResult.PASSED || filter == IRecordedAudio.FilterResult.TOO_LONG)) {
            VoiceChatRecording.LOGGER.debug("remembering");
            VoiceChatRecording.storedAudios.add(event.getAudio());
        }
    }
}

