/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.voicechat;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.util.Pair;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.VolumeCategory;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.events.PlayerConnectedEvent;
import de.maxhenkel.voicechat.api.events.PlayerDisconnectedEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import dev.omialien.voicechatrecording.api.IRecordedPlayer;
import dev.omialien.voicechatrecording.api.VoiceChatRecordingApi;
import dev.omialien.voicechatrecording.api.events.AudioLoadedEvent;
import dev.omialien.voicechatrecording.api.events.MicPacketReceivedEvent;
import dev.omialien.voicechatrecording.api.events.RecordingSetupEvent;
import dev.omialien.voicechatrecording.configs.RecordingCommonConfig;
import dev.omialien.voicechatrecording.taskscheduler.TaskScheduler;
import dev.omialien.voicechatrecording.voicechat.RecordedAudio;
import dev.omialien.voicechatrecording.voicechat.RecordedPlayer;
import dev.omialien.voicechatrecording.voicechat.audio.AudioCache;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

@ForgeVoicechatPlugin
public class VoiceChatRecordingPlugin
implements VoicechatPlugin,
VoiceChatRecordingApi {
    private static final Gson gson = new Gson();
    private Map<UUID, RecordedPlayer> recordedPlayers;
    private Map<UUID, Boolean> privacyMode;
    private ExecutorService audioLoader;
    public Map<String, Set<Pair<UUID, UUID>>> savedAudios;
    public Map<String, Set<RecordedAudio>> audiosToWriteToDisk;
    private Queue<Pair<String, RecordedAudio>> audiosToSave;
    public TaskScheduler audioSavingTask;
    private boolean audioSavingTaskScheduled = false;
    private Thread audioSavingThread;
    private AudioCache audioCache;

    private void createAudioSavingThread() {
        VoiceChatRecording.LOGGER.debug("Recreating saving thread");
        this.audioSavingThread = new Thread(() -> {
            VoiceChatRecording.LOGGER.debug("Running saving thread");
            ExecutorService savePool = Executors.newFixedThreadPool((Integer)RecordingCommonConfig.AUDIO_SAVER_THREAD_COUNT.get());
            Path basePath = RecordedAudio.audiosPath;
            long start = System.nanoTime();
            for (String namespace : this.savedAudios.keySet()) {
                VoiceChatRecording.LOGGER.debug("Saving audios for namespace {}", (Object)namespace);
                Set<Pair<UUID, UUID>> audioIds = this.savedAudios.get(namespace);
                try {
                    Path namespacePath = basePath.resolve(String.format("%s.json", namespace));
                    Files.deleteIfExists(namespacePath);
                    PrintWriter writer = new PrintWriter(namespacePath.toFile());
                    Set audios = audioIds.stream().map(audio -> new Pair((Object)((UUID)audio.getFirst()), (Object)((UUID)audio.getSecond()))).collect(Collectors.toSet());
                    writer.println(gson.toJson(audios));
                    writer.close();
                    VoiceChatRecording.LOGGER.debug("Wrote namespace file {}.json with {} audios", (Object)namespace, (Object)audios.size());
                }
                catch (IOException e) {
                    VoiceChatRecording.LOGGER.error("Couldn't save json file for namespace {}!", (Object)namespace);
                    VoiceChatRecording.LOGGER.error("{}", (Object)e.getMessage());
                }
                if (!this.audiosToWriteToDisk.containsKey(namespace)) {
                    VoiceChatRecording.LOGGER.debug("No new audios to save for {}", (Object)namespace);
                    continue;
                }
                Set<RecordedAudio> audios = this.audiosToWriteToDisk.get(namespace);
                for (RecordedAudio audio2 : audios) {
                    Path audioPath = basePath.resolve(audio2.fileName());
                    if (!Files.exists(audioPath, new LinkOption[0])) {
                        try {
                            Files.createFile(audioPath, new FileAttribute[0]);
                            savePool.submit(() -> {
                                VoiceChatRecording.LOGGER.debug("saving {}", (Object)audioPath);
                                try {
                                    try (FileOutputStream fos = new FileOutputStream(audioPath.toFile());){
                                        FileChannel out = fos.getChannel();
                                        short[] audioData = audio2.getAudio();
                                        ByteBuffer buffer = ByteBuffer.allocate(audioData.length * 2);
                                        buffer.order(ByteOrder.BIG_ENDIAN).asShortBuffer().put(audioData);
                                        for (long written = 0L; written < (long)audioData.length * 2L; written += (long)out.write(buffer)) {
                                        }
                                    }
                                    VoiceChatRecording.LOGGER.debug("Finished writing {} to file", (Object)audioPath);
                                }
                                catch (FileNotFoundException e) {
                                    VoiceChatRecording.LOGGER.error("Couldn't find newly created file? {}", (Object)audioPath);
                                    VoiceChatRecording.LOGGER.error("{}", (Object)e.getMessage());
                                }
                                catch (IOException e) {
                                    VoiceChatRecording.LOGGER.error("Error writing file! {}", (Object)audioPath);
                                    VoiceChatRecording.LOGGER.error("{}", (Object)e.getMessage());
                                }
                            });
                        }
                        catch (IOException e) {
                            VoiceChatRecording.LOGGER.error("Error creating audio file {} !", (Object)audioPath);
                            VoiceChatRecording.LOGGER.error("{}", (Object)e.getMessage());
                        }
                        continue;
                    }
                    VoiceChatRecording.LOGGER.debug("Audio {} already exists, UUIDs are the same so content must be the same", (Object)audioPath);
                }
            }
            savePool.close();
            long end = System.nanoTime();
            VoiceChatRecording.LOGGER.info("Finished saving audios in {}ms", (Object)((double)(end - start) / 1000000.0));
            this.audiosToWriteToDisk.clear();
            this.audioSavingTaskScheduled = false;
            while (!this.audiosToSave.isEmpty()) {
                Pair<String, RecordedAudio> pair;
                if (!this.audioSavingTaskScheduled) {
                    this.audioSavingTaskScheduled = true;
                    this.audioSavingTask.schedule(this::saveAudios, ((Integer)RecordingCommonConfig.AUDIO_SAVING_COOLDOWN.get()).intValue());
                }
                if (!this.audiosToWriteToDisk.containsKey((pair = this.audiosToSave.remove()).getFirst())) {
                    this.audiosToWriteToDisk.put((String)pair.getFirst(), new HashSet());
                }
                this.audiosToWriteToDisk.get(pair.getFirst()).add((RecordedAudio)pair.getSecond());
            }
            HashSet allAudios = new HashSet();
            this.savedAudios.values().forEach(allAudios::addAll);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(basePath);){
                for (Path cur : stream) {
                    Pair<UUID, UUID> ids = RecordedAudio.getIdFromFile(cur);
                    if (ids == null || allAudios.contains(ids)) continue;
                    VoiceChatRecording.LOGGER.info("Deleting unsaved audio file {}", (Object)cur);
                    Files.delete(cur);
                }
            }
            catch (IOException e) {
                VoiceChatRecording.LOGGER.error("Couldn't open audio directory for file deletion");
            }
        });
        this.audioSavingThread.setName("Audio Saving Thread");
    }

    public String getPluginId() {
        return "voicechatrecording";
    }

    public void shutdownSaving() throws InterruptedException {
        this.audioSavingTask = new TaskScheduler();
        this.audioSavingTaskScheduled = false;
        if (this.audioSavingThread == null || !this.audioSavingThread.isAlive()) {
            while (!this.audiosToSave.isEmpty()) {
                Pair<String, RecordedAudio> pair = this.audiosToSave.remove();
                if (!this.audiosToWriteToDisk.containsKey(pair.getFirst())) {
                    this.audiosToWriteToDisk.put((String)pair.getFirst(), new HashSet());
                }
                this.audiosToWriteToDisk.get(pair.getFirst()).add((RecordedAudio)pair.getSecond());
            }
            this.createAudioSavingThread();
            this.audioSavingThread.start();
        }
        VoiceChatRecording.LOGGER.info("Running audio saving thread before shutdown...");
        this.audioSavingThread.join();
    }

    public void shutdownAudioLoading() {
        this.audioLoader.shutdownNow();
        this.audioCache.interruptThread();
    }

    public void initialize(VoicechatApi api) {
        VoiceChatRecording.recordingApi = this;
    }

    private void onServerStarted(VoicechatServerStartedEvent event) {
        VoicechatServerApi api;
        VoiceChatRecording.LOGGER.debug("Initializing Recording API");
        VoiceChatRecording.vcApi = api = event.getVoicechat();
        VoiceChatRecording.recordingApi = this;
        if (this.audioCache != null) {
            this.audioCache.interruptThread();
        }
        this.audioCache = new AudioCache();
        this.audiosToWriteToDisk = new ConcurrentHashMap<String, Set<RecordedAudio>>();
        this.savedAudios = new ConcurrentHashMap<String, Set<Pair<UUID, UUID>>>();
        this.audiosToSave = new ConcurrentLinkedQueue<Pair<String, RecordedAudio>>();
        this.audioSavingTask = new TaskScheduler();
        this.audioSavingTaskScheduled = false;
        this.audioLoader = Executors.newFixedThreadPool((Integer)RecordingCommonConfig.AUDIO_READER_THREAD_COUNT.get());
        if (this.audioSavingThread != null && this.audioSavingThread.isAlive()) {
            try {
                VoiceChatRecording.LOGGER.debug("joining saving thread");
                this.audioSavingThread.join();
                VoiceChatRecording.LOGGER.debug("finished join");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.createAudioSavingThread();
        try {
            this.loadNamespaceFiles();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.recordedPlayers = new ConcurrentHashMap<UUID, RecordedPlayer>();
        this.privacyMode = new ConcurrentHashMap<UUID, Boolean>();
        VoiceChatRecording.LOGGER.debug("STARTING SCHEDULER");
        VoiceChatRecording.TASKS.schedule(this::checkForSilence, 20L);
        RecordingSetupEvent eventResult = (RecordingSetupEvent)NeoForge.EVENT_BUS.post((Event)new RecordingSetupEvent(this));
        Iterator<VolumeCategory> it = eventResult.getCategories();
        while (it.hasNext()) {
            VolumeCategory cat = it.next();
            VoiceChatRecording.LOGGER.debug("Registering category {}", (Object)cat.getName());
            api.registerVolumeCategory(cat);
        }
    }

    private void saveAudios() {
        if (this.audioSavingThread.isAlive()) {
            VoiceChatRecording.LOGGER.warn("Tried to save audios while thread was started: trying again in 5 minutes");
            this.audioSavingTask.schedule(this::saveAudios, ((Integer)RecordingCommonConfig.AUDIO_SAVING_COOLDOWN.get()).intValue());
        } else {
            this.createAudioSavingThread();
            this.audioSavingThread.start();
        }
    }

    public void saveAudio(String namespace, RecordedAudio audio) {
        VoiceChatRecording.LOGGER.debug("PLUGIN saving audio {} {}", (Object)namespace, (Object)audio.getId());
        if (!this.savedAudios.containsKey(namespace)) {
            this.savedAudios.put(namespace, new HashSet());
        }
        this.savedAudios.get(namespace).add((Pair<UUID, UUID>)new Pair((Object)audio.getPlayerUUID(), (Object)audio.getId()));
        if (this.audioSavingThread.isAlive()) {
            VoiceChatRecording.LOGGER.debug("thread is alive, adding to queue");
            this.audiosToSave.add((Pair<String, RecordedAudio>)new Pair((Object)namespace, (Object)audio));
        } else {
            VoiceChatRecording.LOGGER.debug("adding saved audio to map");
            if (!this.audiosToWriteToDisk.containsKey(namespace)) {
                this.audiosToWriteToDisk.put(namespace, new HashSet());
            }
            this.audiosToWriteToDisk.get(namespace).add(audio);
        }
        if (!this.audioSavingTaskScheduled) {
            this.audioSavingTaskScheduled = true;
            int cd = (Integer)RecordingCommonConfig.AUDIO_SAVING_COOLDOWN.get();
            VoiceChatRecording.LOGGER.info("Audios will be saved in {} seconds...", (Object)(cd / 20));
            this.audioSavingTask.schedule(this::saveAudios, cd);
        }
    }

    @Override
    public void unsaveAudio(String namespace, IRecordedAudio audio) {
        if (this.savedAudios.containsKey(namespace)) {
            this.savedAudios.get(namespace).remove(new Pair((Object)audio.getPlayerUUID(), (Object)audio.getId()));
        }
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(MicrophonePacketEvent.class, this::onMicrophonePacket, 100);
        registration.registerEvent(VoicechatServerStartedEvent.class, this::onServerStarted, 100);
        registration.registerEvent(PlayerConnectedEvent.class, this::onPlayerConnected, 100);
        registration.registerEvent(PlayerDisconnectedEvent.class, this::onPlayerDisconnected, 100);
    }

    private void onMicrophonePacket(MicrophonePacketEvent e) {
        if (e.getSenderConnection() != null) {
            RecordedPlayer recordedPlayer = this.recordedPlayers.get(e.getSenderConnection().getPlayer().getUuid());
            recordedPlayer.recordPacket(((MicrophonePacket)e.getPacket()).getOpusEncodedData());
            MicPacketReceivedEvent ev = new MicPacketReceivedEvent(e);
            NeoForge.EVENT_BUS.post((Event)ev);
        }
    }

    private void loadNamespaceFiles() throws IOException {
        Path basePath = RecordedAudio.audiosPath;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(basePath);){
            for (Path curNamespace : directoryStream) {
                String filename = curNamespace.getFileName().toString();
                if (!filename.endsWith(".json")) continue;
                String namespace = filename.substring(0, filename.lastIndexOf(46));
                VoiceChatRecording.LOGGER.info("Loading namespace {}", (Object)namespace);
                JsonReader reader = new JsonReader((Reader)new FileReader(curNamespace.toFile()));
                Set audioIds = (Set)gson.fromJson(reader, new TypeToken<Set<Pair<UUID, UUID>>>(this){}.getType());
                if (!this.savedAudios.containsKey(namespace)) {
                    this.savedAudios.put(namespace, new HashSet());
                }
                for (Pair id : audioIds) {
                    this.savedAudios.get(namespace).add((Pair<UUID, UUID>)id);
                    VoiceChatRecording.LOGGER.debug("{}: {} {}", new Object[]{namespace, id.getFirst(), id.getSecond()});
                }
            }
        }
    }

    private IRecordedAudio readAudioFromFile(Path audioPath, Consumer<IRecordedAudio> reaction, Pair<UUID, UUID> ids) {
        short[] audio;
        try {
            byte[] byts = Files.readAllBytes(audioPath);
            short[] shrts = new short[byts.length / 2];
            ByteBuffer.wrap(byts).order(ByteOrder.BIG_ENDIAN).asShortBuffer().get(shrts);
            audio = shrts;
        }
        catch (FileNotFoundException e) {
            VoiceChatRecording.LOGGER.error("Tried to load non-existent audio {}", (Object)audioPath);
            reaction.accept(null);
            return null;
        }
        catch (IOException e) {
            VoiceChatRecording.LOGGER.error("Error loading audio: {}", (Object)audioPath);
            VoiceChatRecording.LOGGER.error("{}", (Object)e.getMessage());
            reaction.accept(null);
            return null;
        }
        RecordedAudio audioObj = new RecordedAudio(audio, (UUID)ids.getFirst(), (UUID)ids.getSecond());
        reaction.accept(audioObj);
        return audioObj;
    }

    @Nullable
    private Future<IRecordedAudio> loadRawAudio(Pair<UUID, UUID> ids, AudioLoadedEvent.LoadType type, Consumer<IRecordedAudio> reaction, String namespace) {
        Path audioPath = RecordedAudio.audiosPath.resolve(RecordedAudio.getFileName((UUID)ids.getFirst(), (UUID)ids.getSecond()));
        VoiceChatRecording.LOGGER.debug("Checking cache...");
        RecordedAudio id = RecordedAudio.makeIdentificationAudio((UUID)ids.getFirst(), (UUID)ids.getSecond());
        AtomicReference<Object> found = new AtomicReference<Object>(null);
        this.audiosToWriteToDisk.values().forEach(set -> {
            if (set.contains(id)) {
                for (RecordedAudio audio : set) {
                    if (!audio.equals(id)) continue;
                    found.set(audio);
                    return;
                }
            }
        });
        if (found.get() != null) {
            return this.audioLoader.submit(found::get);
        }
        if (this.audioCache.isCached(ids)) {
            Future<IRecordedAudio> cached = this.audioCache.get(ids);
            if (cached.state() == Future.State.SUCCESS) {
                try {
                    IRecordedAudio audio = cached.get();
                    reaction.accept(audio);
                    NeoForge.EVENT_BUS.post((Event)new AudioLoadedEvent(audio, type, namespace));
                }
                catch (Exception e) {
                    VoiceChatRecording.LOGGER.error("Error getting successfully finished audio from cache to event: {} {}", ids.getFirst(), ids.getSecond());
                    VoiceChatRecording.LOGGER.error("{}", (Object)e.getMessage());
                }
            }
            return cached;
        }
        VoiceChatRecording.LOGGER.debug("Not in cache, adding");
        this.audioCache.add(ids, this.audioLoader.submit(() -> {
            IRecordedAudio res = this.readAudioFromFile(audioPath, reaction, ids);
            NeoForge.EVENT_BUS.post((Event)new AudioLoadedEvent(res, type, namespace));
            return res;
        }));
        VoiceChatRecording.LOGGER.debug("Added");
        return this.audioCache.get(ids);
    }

    private Future<IRecordedAudio> loadRawAudio(Pair<UUID, UUID> ids, AudioLoadedEvent.LoadType type, Consumer<IRecordedAudio> reaction) {
        return this.loadRawAudio(ids, type, reaction, "");
    }

    private Future<IRecordedAudio> loadRawAudio(Pair<UUID, UUID> ids, AudioLoadedEvent.LoadType type, String namespace) {
        return this.loadRawAudio(ids, type, audio -> {}, namespace);
    }

    private Future<IRecordedAudio> loadRawAudio(Pair<UUID, UUID> ids, AudioLoadedEvent.LoadType type) {
        return this.loadRawAudio(ids, type, "");
    }

    @Override
    public Set<Future<IRecordedAudio>> loadNamespaceAudios(String namespace, Consumer<IRecordedAudio> reaction) {
        if (!this.savedAudios.containsKey(namespace)) {
            VoiceChatRecording.LOGGER.warn("Tried to load from non-existent namespace {}", (Object)namespace);
            return Collections.emptySet();
        }
        Set<Pair<UUID, UUID>> toLoad = this.savedAudios.get(namespace);
        HashSet<Future<IRecordedAudio>> loadedAudios = new HashSet<Future<IRecordedAudio>>(toLoad.size());
        for (Pair<UUID, UUID> cur : toLoad) {
            loadedAudios.add(this.loadRawAudio(cur, AudioLoadedEvent.LoadType.NAMESPACE, reaction, namespace));
        }
        return loadedAudios;
    }

    @Override
    public Set<Future<IRecordedAudio>> loadNamespaceAudios(String namespace) {
        return this.loadNamespaceAudios(namespace, audio -> {});
    }

    @Override
    public Set<Pair<UUID, UUID>> getNamespaceAudios(String namespace) {
        return Collections.unmodifiableSet(this.savedAudios.getOrDefault(namespace, Collections.emptySet()));
    }

    @Override
    public Future<IRecordedAudio> loadAudio(UUID playerUuid, UUID audioId, Consumer<IRecordedAudio> reaction) {
        return this.loadRawAudio((Pair<UUID, UUID>)new Pair((Object)playerUuid, (Object)audioId), AudioLoadedEvent.LoadType.SINGLE, reaction);
    }

    @Override
    public Future<IRecordedAudio> loadAudio(UUID playerUuid, UUID audioId) {
        return this.loadAudio(playerUuid, audioId, audio -> {});
    }

    @Override
    public Set<Future<IRecordedAudio>> loadPlayerAudios(UUID playerUuid, Consumer<IRecordedAudio> reaction) {
        HashSet<Future<IRecordedAudio>> loadedAudios = new HashSet<Future<IRecordedAudio>>(this.savedAudios.size() * 50);
        this.savedAudios.values().stream().flatMap(Collection::stream).forEach(audio -> loadedAudios.add(this.loadRawAudio((Pair<UUID, UUID>)audio, AudioLoadedEvent.LoadType.ALL_FROM_USER, reaction)));
        return loadedAudios;
    }

    @Override
    public Set<Future<IRecordedAudio>> loadPlayerAudios(UUID playerUuid) {
        return this.loadPlayerAudios(playerUuid, audio -> {});
    }

    private void onPlayerConnected(PlayerConnectedEvent e) {
        UUID playerUuid = e.getConnection().getPlayer().getUuid();
        RecordedPlayer player = new RecordedPlayer(playerUuid);
        this.recordedPlayers.put(playerUuid, player);
        this.startRecording(playerUuid);
    }

    private void onPlayerDisconnected(PlayerDisconnectedEvent e) {
        UUID pid = e.getPlayerUuid();
        this.stopRecording(pid);
        if (this.getPrivacy(pid)) {
            this.privacyMode.remove(pid);
        }
        this.recordedPlayers.remove(pid);
    }

    public void stopRecording(UUID uuid) {
        this.recordedPlayers.get(uuid).saveCurrentRecording();
        VoiceChatRecording.LOGGER.debug("Stopped recording for player: {}", (Object)uuid.toString());
    }

    public void startRecording(UUID uuid) {
        this.recordedPlayers.get(uuid).startRecording();
        VoiceChatRecording.LOGGER.debug("Recording started for player: {}", (Object)uuid.toString());
    }

    @Override
    public IRecordedPlayer getRecordedPlayer(UUID uuid) {
        return this.recordedPlayers.getOrDefault(uuid, null);
    }

    @Override
    public boolean getPrivacy(UUID uuid) {
        return this.privacyMode.getOrDefault(uuid, true);
    }

    public void setPrivacy(UUID uuid, boolean state) {
        VoiceChatRecording.LOGGER.debug("set privacy mode {} of {}", (Object)state, (Object)uuid);
        this.privacyMode.put(uuid, state);
    }

    private void checkForSilence() {
        for (RecordedPlayer player : this.recordedPlayers.values()) {
            if (player.isSpeaking() || player.isSilent()) continue;
            VoiceChatRecording.LOGGER.debug("Stopped Speaking!");
            this.stopRecording(player.getUuid());
            player.setSilent(true);
        }
        VoiceChatRecording.TASKS.schedule(this::checkForSilence, 25L);
    }
}

