/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.api.AudioEffect;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import dev.omialien.voicechatrecording.api.util.AudioPlayingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NearestEntityPlayVoiceCommand {
    public static final int PERMISSION_LEVEL = 2;
    private static final float CHANNEL_DISTANCE = 20.0f;
    public static final int bbX = 5;
    public static final int bbY = 5;
    public static final int bbZ = 5;

    private static LiteralArgumentBuilder<CommandSourceStack> PITCH_ARG(Command<CommandSourceStack> cmd) {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"pitch").then(Commands.m_82129_((String)"pitchFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(cmd));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> REVERB_ARG(Command<CommandSourceStack> cmd) {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"reverb").then(Commands.m_82129_((String)"decay", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.m_82129_((String)"delay-ms", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"repeats", (ArgumentType)IntegerArgumentType.integer()).executes(cmd))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> ROBOT_ARG(Command<CommandSourceStack> cmd) {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"robot").then(Commands.m_82129_((String)"lfo-frequency", (ArgumentType)FloatArgumentType.floatArg()).executes(cmd));
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"playVoice").requires(src -> src.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"uuid", (ArgumentType)UuidArgument.m_113850_()).suggests((src, suggestionsBuilder) -> SharedSuggestionProvider.m_82981_(VoiceChatRecording.storedAudios.stream().map(r -> r.getId().toString()), (SuggestionsBuilder)suggestionsBuilder)).executes(ctx -> {
            VoiceChatRecording.LOGGER.debug("id");
            return NearestEntityPlayVoiceCommand.runCommand((CommandContext<CommandSourceStack>)ctx, null, UuidArgument.m_113853_((CommandContext)ctx, (String)"uuid"), null);
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91460_()).executes(ctx -> {
            VoiceChatRecording.LOGGER.debug("ent id");
            return NearestEntityPlayVoiceCommand.runCommand((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91461_((CommandContext)ctx, (String)"entity"), UuidArgument.m_113853_((CommandContext)ctx, (String)"uuid"), null);
        })).then(NearestEntityPlayVoiceCommand.PITCH_ARG((Command<CommandSourceStack>)((Command)ctx -> {
            VoiceChatRecording.LOGGER.debug("ent id pitch");
            return NearestEntityPlayVoiceCommand.runCommand((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91461_((CommandContext)ctx, (String)"entity"), UuidArgument.m_113853_((CommandContext)ctx, (String)"uuid"), AudioEffect.pitch(FloatArgumentType.getFloat((CommandContext)ctx, (String)"pitchFactor")));
        })))).then(NearestEntityPlayVoiceCommand.REVERB_ARG((Command<CommandSourceStack>)((Command)ctx -> {
            VoiceChatRecording.LOGGER.debug("ent id reverb");
            float decay = FloatArgumentType.getFloat((CommandContext)ctx, (String)"decay");
            int delay = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"delay-ms");
            int repeats = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"repeats");
            return NearestEntityPlayVoiceCommand.runCommand((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91461_((CommandContext)ctx, (String)"entity"), UuidArgument.m_113853_((CommandContext)ctx, (String)"uuid"), AudioEffect.reverb(decay, delay, repeats));
        })))).then(NearestEntityPlayVoiceCommand.ROBOT_ARG((Command<CommandSourceStack>)((Command)ctx -> {
            VoiceChatRecording.LOGGER.debug("ent id robot");
            return NearestEntityPlayVoiceCommand.runCommand((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91461_((CommandContext)ctx, (String)"entity"), UuidArgument.m_113853_((CommandContext)ctx, (String)"uuid"), AudioEffect.robot(FloatArgumentType.getFloat((CommandContext)ctx, (String)"lfo-frequency")));
        })))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            VoiceChatRecording.LOGGER.debug("ent id random");
            return NearestEntityPlayVoiceCommand.runCommand((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91461_((CommandContext)ctx, (String)"entity"), UuidArgument.m_113853_((CommandContext)ctx, (String)"uuid"), AudioEffect.random());
        })))));
    }

    private static LivingEntity getNearestEntity(CommandContext<CommandSourceStack> ctx) {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        Vec3 srcPos = ((CommandSourceStack)ctx.getSource()).m_81371_();
        AABB aabb = new AABB(srcPos.f_82479_ + 5.0, srcPos.f_82480_ + 5.0, srcPos.f_82481_ + 5.0, srcPos.f_82479_ - 5.0, srcPos.f_82480_ - 5.0, srcPos.f_82481_ - 5.0);
        return level.m_45963_(LivingEntity.class, TargetingConditions.f_26872_, null, srcPos.f_82479_, srcPos.f_82480_, srcPos.f_82481_, aabb);
    }

    private static void playAudio(CommandContext<CommandSourceStack> ctx, Entity entity, UUID id, AudioEffect effects) {
        VoiceChatRecording.LOGGER.debug("Entity: " + entity.m_7755_());
        IRecordedAudio audio = null;
        for (IRecordedAudio cur : VoiceChatRecording.storedAudios) {
            if (!cur.getId().equals(id)) continue;
            audio = cur;
            break;
        }
        if (audio != null) {
            Player player = entity.m_9236_().m_46003_(audio.getPlayerUUID());
            String playerName = player == null ? audio.getPlayerUUID().toString() : player.m_7755_().getString();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Playing audio of " + playerName + " from ")).m_7220_(entity.m_7755_()), true);
            AudioPlayingUtil.playFromEntity(audio, entity, effects, "recording_vc", 20.0f);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid ID " + id)));
        }
    }

    public static int runCommand(CommandContext<CommandSourceStack> ctx, @Nullable Collection<? extends Entity> targets, UUID id, AudioEffect effects) {
        try {
            List<Entity> entities;
            List<Entity> list = entities = targets == null ? null : targets.stream().map(e -> e).toList();
            if (entities == null) {
                LivingEntity nearestEntity = NearestEntityPlayVoiceCommand.getNearestEntity(ctx);
                if (nearestEntity == null) {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No entity found!"));
                    return 20;
                }
                entities = new ArrayList<Entity>();
                entities.add((Entity)nearestEntity);
            }
            for (Entity audioTarget : entities) {
                NearestEntityPlayVoiceCommand.playAudio(ctx, audioTarget, id, effects);
            }
            return 0;
        }
        catch (Exception e2) {
            VoiceChatRecording.LOGGER.error("Error running playVoice: {}\r\n{}", (Object)e2.getMessage(), (Object)e2.getStackTrace());
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)e2.getMessage()));
            return 100;
        }
    }
}

