/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import dev.omialien.voicechatrecording.commands.CommandUtil;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class SaveAudioCommand {
    public static final int PERMISSION_LEVEL = 2;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"saveAudio").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)UuidArgument.m_113850_()).suggests((src, suggestionsBuilder) -> SharedSuggestionProvider.m_82981_(CommandUtil.getRememberedAudios().map(r -> r.getPlayerUUID().toString()), (SuggestionsBuilder)suggestionsBuilder)).then(Commands.m_82129_((String)"audio", (ArgumentType)UuidArgument.m_113850_()).suggests((src, suggestionsBuilder) -> SharedSuggestionProvider.m_82981_(CommandUtil.getRememberedAudios().map(r -> r.getId().toString()), (SuggestionsBuilder)suggestionsBuilder)).executes(SaveAudioCommand::runCommand))));
    }

    private static int runCommand(CommandContext<CommandSourceStack> src) {
        UUID player = UuidArgument.m_113853_(src, (String)"player");
        UUID audioId = UuidArgument.m_113853_(src, (String)"audio");
        for (IRecordedAudio audio : VoiceChatRecording.storedAudios) {
            if (!audio.getPlayerUUID().equals(player) || !audio.getId().equals(audioId)) continue;
            boolean res = audio.saveAudio("voicechatrecording");
            if (res) {
                StringBuilder builder = new StringBuilder("Saved audio ");
                builder.append(audioId);
                builder.append(" by ");
                Player p = ((CommandSourceStack)src.getSource()).m_81372_().m_46003_(player);
                builder.append(p == null ? player : p.m_7755_().getString());
                ((CommandSourceStack)src.getSource()).m_288197_(() -> Component.m_237113_((String)builder.toString()), true);
            } else {
                ((CommandSourceStack)src.getSource()).m_81352_((Component)Component.m_237113_((String)"Could not save audio!"));
                if (VoiceChatRecording.recordingApi.getPrivacy(player)) {
                    ((CommandSourceStack)src.getSource()).m_81352_((Component)Component.m_237113_((String)"Player has privacy mode enabled"));
                } else {
                    ((CommandSourceStack)src.getSource()).m_81352_((Component)Component.m_237113_((String)"Unknown reason"));
                }
            }
            return 0;
        }
        ((CommandSourceStack)src.getSource()).m_81352_((Component)Component.m_237113_((String)"Audio not found"));
        return 1;
    }
}

