/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.events;

import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.configs.RecordingClientConfig;
import dev.omialien.voicechatrecording.networking.PrivacyModePacket;
import dev.omialien.voicechatrecording.networking.ServerPayloadHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="voicechatrecording", value={Dist.CLIENT})
public class ClientEventBus {
    private static void sendPrivacyPacket() {
        if (Minecraft.m_91087_().m_91403_() != null) {
            PrivacyModePacket packet = new PrivacyModePacket((Boolean)RecordingClientConfig.PRIVACY.get());
            VoiceChatRecording.LOGGER.debug("Client Sending privacy mode packet");
            ServerPayloadHandler.INSTANCE.sendToServer((Object)packet);
        } else {
            VoiceChatRecording.LOGGER.debug("Tried to send packet without connection");
        }
    }

    @SubscribeEvent
    public static void onClientJoinLevel(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof LocalPlayer) {
            ClientEventBus.sendPrivacyPacket();
        }
    }

    @SubscribeEvent
    public static void onConfigChange(ModConfigEvent.Reloading e) {
        ClientEventBus.sendPrivacyPacket();
    }
}

