/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.networking;

import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.voicechat.VoiceChatRecordingPlugin;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class PrivacyModePacket {
    private final boolean state;

    public PrivacyModePacket(boolean s) {
        VoiceChatRecording.LOGGER.debug("Created PrivacyModePacket");
        this.state = s;
    }

    public void encode(FriendlyByteBuf buffer) {
        VoiceChatRecording.LOGGER.debug("Encoded PrivacyModePacket");
        buffer.writeBoolean(this.state);
    }

    public static PrivacyModePacket decode(FriendlyByteBuf buffer) {
        VoiceChatRecording.LOGGER.debug("Decoded PrivacyModePacket");
        return new PrivacyModePacket(buffer.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        VoiceChatRecording.LOGGER.debug("Handling PrivacyModePacket");
        ctx.get().enqueueWork(() -> {
            VoiceChatRecording.LOGGER.debug("PrivacyModePacket received!");
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null) {
                VoiceChatRecording.LOGGER.debug("Setting privacy mode for {} to {}", (Object)sender.m_7755_(), (Object)this.state);
                ((VoiceChatRecordingPlugin)VoiceChatRecording.recordingApi).setPrivacy(sender.m_20148_(), this.state);
            } else {
                VoiceChatRecording.LOGGER.warn("Received PrivacyModePacket without sender?");
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

