/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.taskscheduler;

import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.taskscheduler.Task;

public class TaskScheduler {
    private Task nextTask = null;
    private long time = 0L;

    public void tick() {
        if (this.nextTask != null) {
            Task cur;
            ++this.time;
            for (cur = this.nextTask; cur != null && cur.getTime() <= this.time; cur = cur.getNext()) {
                cur.run();
            }
            this.nextTask = cur;
        }
    }

    public long getTime() {
        return this.time;
    }

    public void schedule(Runnable method, long ticks) {
        long timeToRun = this.time + ticks;
        Task toInsert = new Task(timeToRun, method);
        Task last = null;
        Task cur = this.nextTask;
        if (cur != null) {
            while (cur.getTime() <= timeToRun) {
                Task next = cur.getNext();
                if (next == null) {
                    cur.setNext(toInsert);
                    return;
                }
                last = cur;
                cur = cur.getNext();
            }
            if (last == null) {
                this.nextTask = toInsert;
                this.nextTask.setNext(cur);
            } else {
                toInsert.setNext(cur);
                last.setNext(toInsert);
            }
        } else {
            this.nextTask = toInsert;
        }
    }

    public void scheduleAt(Runnable method, long when) {
        this.schedule(method, when - this.time);
    }

    public void debug() {
        for (Task cur = this.nextTask; cur != null; cur = cur.getNext()) {
            VoiceChatRecording.LOGGER.debug("Executed at: {}", (Object)cur.getTime());
            cur.run();
        }
    }
}

