/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.voicechat;

import com.mojang.datafixers.util.Pair;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.api.AudioEffect;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import dev.omialien.voicechatrecording.configs.RecordingCommonConfig;
import dev.omialien.voicechatrecording.voicechat.VoiceChatRecordingPlugin;
import java.nio.file.Path;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class RecordedAudio
implements IRecordedAudio {
    public final int SAMPLE_RATE = 48000;
    public static Path audiosPath;
    private final short[] audio;
    private final UUID id;
    private final UUID player;
    private int activeSamplesCache;
    private double rmsCache;
    private boolean calculatedCaches = false;

    public RecordedAudio(short[] audio, UUID player) {
        this(audio, player, UUID.randomUUID());
    }

    public RecordedAudio(short[] audio, UUID player, UUID id) {
        this.audio = audio;
        this.player = player;
        this.id = id;
    }

    @Override
    public short[] getAudio() {
        return this.audio;
    }

    @Override
    public UUID getPlayerUUID() {
        return this.player;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public boolean saveAudio(String namespace) {
        boolean privacy = VoiceChatRecording.recordingApi.getPrivacy(this.player);
        if (!privacy) {
            ((VoiceChatRecordingPlugin)VoiceChatRecording.recordingApi).saveAudio(namespace, this);
            return true;
        }
        return false;
    }

    @Override
    public void unsaveAudio(String namespace) {
        VoiceChatRecording.recordingApi.unsaveAudio(namespace, this);
    }

    @Override
    public short[] applyEffects(@Nullable AudioEffect effect) {
        return effect == null ? this.getAudio() : effect.applyEffects((short[])this.getAudio().clone());
    }

    @Override
    public IRecordedAudio.FilterResult getFilterResult() {
        double MIN_DURATION = 0.9;
        double MAX_DURATION = 10.0;
        double MIN_RMS = 500.0;
        double duration = this.getDuration();
        if (duration <= 0.9) {
            return IRecordedAudio.FilterResult.TOO_SHORT;
        }
        if (duration > 10.0) {
            return IRecordedAudio.FilterResult.TOO_LONG;
        }
        if (this.getActiveSamples() <= 0) {
            return IRecordedAudio.FilterResult.NO_ACTIVE_AUDIO;
        }
        return this.getRms() >= 500.0 ? IRecordedAudio.FilterResult.PASSED : IRecordedAudio.FilterResult.LOW_RMS;
    }

    @Override
    public double getDuration() {
        return (double)this.audio.length / 48000.0;
    }

    @Override
    public double getActiveDuration() {
        return (double)this.getActiveSamples() / 48000.0;
    }

    public String getAudioInfo() {
        return String.format("Audio duration: %.3fs, Active region: %.3fs, RMS: %.1f", this.getDuration(), (double)this.getActiveSamples() / 48000.0, this.getRms());
    }

    private void calculateCaches() {
        int end;
        int start;
        this.calculatedCaches = true;
        for (start = 0; start < this.audio.length && Math.abs(this.audio[start]) < (Integer)RecordingCommonConfig.SILENCE_THRESHOLD.get(); ++start) {
        }
        for (end = this.audio.length - 1; end > start && Math.abs(this.audio[end]) < (Integer)RecordingCommonConfig.SILENCE_THRESHOLD.get(); --end) {
        }
        int activeSamples = end - start + 1;
        long sumSquares = 0L;
        for (int i = start; i <= end; ++i) {
            short sample = this.audio[i];
            sumSquares += (long)(sample * sample);
        }
        this.rmsCache = Math.sqrt((double)sumSquares / (double)activeSamples);
        this.activeSamplesCache = activeSamples;
    }

    @Override
    public int getActiveSamples() {
        if (!this.calculatedCaches) {
            this.calculateCaches();
        }
        return this.activeSamplesCache;
    }

    @Override
    public double getRms() {
        if (!this.calculatedCaches) {
            this.calculateCaches();
        }
        return this.rmsCache;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecordedAudio) {
            RecordedAudio other = (RecordedAudio)obj;
            return other.getId().equals(this.getId()) && other.getPlayerUUID().equals(this.getPlayerUUID());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getPlayerUUID());
    }

    public String fileName() {
        return RecordedAudio.getFileName(this.getPlayerUUID(), this.getId());
    }

    public static String getFileName(UUID playerUuid, UUID audioId) {
        return String.format("%s+%s.pcm", playerUuid.toString(), audioId.toString());
    }

    @Nullable
    public static Pair<UUID, UUID> getIdFromFile(Path path) {
        UUID audio;
        UUID player;
        String name = path.getFileName().toString();
        if (!name.endsWith(".pcm")) {
            return null;
        }
        if (name.length() != 77) {
            return null;
        }
        String[] split = name.split(Pattern.quote("+"));
        try {
            player = UUID.fromString(split[0]);
            VoiceChatRecording.LOGGER.debug("player id: {}", (Object)player);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        try {
            audio = UUID.fromString(split[1].split(Pattern.quote(".pcm"))[0]);
            VoiceChatRecording.LOGGER.debug("audio: {}", (Object)audio);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return new Pair((Object)player, (Object)audio);
    }

    public static RecordedAudio makeIdentificationAudio(UUID player, UUID audioId) {
        return new RecordedAudio(null, player, audioId);
    }
}

