/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.voicechat;

import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.api.IRecordedPlayer;
import dev.omialien.voicechatrecording.api.events.AudioRecordedEvent;
import dev.omialien.voicechatrecording.configs.RecordingCommonConfig;
import dev.omialien.voicechatrecording.voicechat.RecordedAudio;
import java.util.UUID;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class RecordedPlayer
implements IRecordedPlayer {
    public static final int RECORDING_SIZE = 0x100000;
    private OpusDecoder decoder = null;
    private final short[] recording;
    private int currentRecordingIndex;
    private int recordingSize;
    private boolean isRecording = false;
    private final UUID uuid;
    private long lastSpoke;
    private static final long NOT_SPOKEN_YET = -1L;
    private boolean isSilent = false;

    public RecordedPlayer(UUID uuid) {
        this.uuid = uuid;
        this.recording = new short[0x100000];
        this.lastSpoke = -1L;
        VoiceChatRecording.LOGGER.debug("Created RecordedPlayer {}", (Object)uuid);
    }

    public void saveCurrentRecording() {
        if (this.isRecording) {
            short[] savedRecording = new short[this.recordingSize];
            System.arraycopy(this.recording, 0, savedRecording, 0, this.recordingSize);
            RecordedAudio recAudio = new RecordedAudio(savedRecording, this.getUuid());
            MinecraftForge.EVENT_BUS.post((Event)new AudioRecordedEvent(recAudio));
            this.currentRecordingIndex = 0;
            this.recordingSize = 0;
        }
    }

    public void recordPacket(byte[] packet) {
        if (this.isRecording) {
            if (this.decoder == null) {
                VoiceChatRecording.LOGGER.warn("Decoder is not initialized!");
                return;
            }
            try {
                short[] decodedPacket = this.decoder.decode(packet);
                if (decodedPacket.length + this.currentRecordingIndex < 0x100000) {
                    boolean active = false;
                    for (short value : decodedPacket) {
                        if (Math.abs(value) < (Integer)RecordingCommonConfig.SILENCE_THRESHOLD.get()) continue;
                        this.setLastSpoke(System.currentTimeMillis());
                        this.setSilent(false);
                        active = true;
                        break;
                    }
                    if (!active && this.currentRecordingIndex < 5) {
                        return;
                    }
                    System.arraycopy(decodedPacket, 0, this.recording, this.currentRecordingIndex, decodedPacket.length);
                    this.currentRecordingIndex += decodedPacket.length;
                    if (active) {
                        this.recordingSize = this.currentRecordingIndex;
                    }
                } else {
                    VoiceChatRecording.LOGGER.warn("Recording buffer full!");
                    this.saveCurrentRecording();
                }
            }
            catch (Exception e) {
                VoiceChatRecording.LOGGER.error("Error decoding packet: {}", (Object)e.getMessage());
            }
        }
    }

    public void startRecording() {
        if (!this.isRecording) {
            this.decoder = VoiceChatRecording.vcApi.createDecoder();
            this.isRecording = true;
        }
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public boolean isRecording() {
        return this.isRecording;
    }

    @Override
    public boolean isSpeaking() {
        return this.getLastSpoke() != -1L && System.currentTimeMillis() - this.getLastSpoke() < 1200L;
    }

    @Override
    public long getLastSpoke() {
        return this.lastSpoke;
    }

    private void setLastSpoke(long lastSpoke) {
        this.lastSpoke = lastSpoke;
    }

    @Override
    public boolean isSilent() {
        return this.isSilent;
    }

    public void setSilent(boolean silent) {
        this.isSilent = silent;
    }
}

