/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.voicechatrecording.voicechat.audio;

import com.mojang.datafixers.util.Pair;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import dev.omialien.voicechatrecording.configs.RecordingCommonConfig;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

public class AudioCache {
    private final Map<Pair<UUID, UUID>, CacheEntry> audioLoadingCache = new ConcurrentHashMap<Pair<UUID, UUID>, CacheEntry>();
    private Thread removalThread;

    public AudioCache() {
        this.restartThread();
    }

    public void interruptThread() {
        if (this.removalThread.isAlive()) {
            this.removalThread.interrupt();
        } else {
            VoiceChatRecording.LOGGER.error("Tried to interrupt cache removal thread while alive!");
            VoiceChatRecording.LOGGER.error("interruption stacktrace: {}", (Object[])Thread.currentThread().getStackTrace());
        }
    }

    private void restartThread() {
        if (this.removalThread != null && this.removalThread.isAlive()) {
            return;
        }
        this.removalThread = new Thread(() -> {
            while (true) {
                VoiceChatRecording.LOGGER.info("Removing old audios from cache");
                long time = System.nanoTime();
                HashSet<Pair<UUID, UUID>> toRemove = new HashSet<Pair<UUID, UUID>>();
                for (Pair<UUID, UUID> curKey : this.audioLoadingCache.keySet()) {
                    CacheEntry cur = this.audioLoadingCache.get(curKey);
                    if (time - cur.getTime() < (long)((Integer)RecordingCommonConfig.CACHE_REMOVAL_TIME.get()).intValue() * 1000000L) continue;
                    VoiceChatRecording.LOGGER.debug("Removing {}", curKey.getSecond());
                    toRemove.add(curKey);
                }
                toRemove.forEach(this.audioLoadingCache::remove);
                VoiceChatRecording.LOGGER.info("Finished removing old audios from cache");
                try {
                    Thread.sleep(Duration.of(((Integer)RecordingCommonConfig.CACHE_CHECK_INTERVAL.get()).intValue(), ChronoUnit.SECONDS).toMillis());
                }
                catch (InterruptedException e) {
                    VoiceChatRecording.LOGGER.warn("Interrupted cache removal thread, finishing");
                    return;
                }
            }
        });
        this.removalThread.start();
    }

    public Future<IRecordedAudio> get(Pair<UUID, UUID> ids) {
        if (this.audioLoadingCache.containsKey(ids)) {
            CacheEntry entry = this.audioLoadingCache.get(ids);
            entry.refresh();
            return entry.getAudio();
        }
        return null;
    }

    public boolean isCached(Pair<UUID, UUID> ids) {
        return this.audioLoadingCache.containsKey(ids);
    }

    public void add(Pair<UUID, UUID> ids, Future<IRecordedAudio> audio) {
        if (this.audioLoadingCache.containsKey(ids)) {
            this.audioLoadingCache.get(ids).refresh();
            return;
        }
        this.audioLoadingCache.put(ids, new CacheEntry(audio, System.nanoTime()));
    }

    static class CacheEntry {
        private final Future<IRecordedAudio> audio;
        private long addedTime;

        public CacheEntry(Future<IRecordedAudio> audio, long addedTime) {
            this.audio = audio;
            this.addedTime = addedTime;
        }

        public void refresh() {
            this.addedTime = System.nanoTime();
        }

        public long getTime() {
            return this.addedTime;
        }

        public Future<IRecordedAudio> getAudio() {
            return this.audio;
        }
    }
}

