/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.dummy;

import de.scholle.dummy.Language;
import de.scholle.dummy.listeners.DummyJoinListener;
import de.scholle.dummy.listeners.DummyListener;
import de.scholle.dummy.listeners.DummyQuitListener;
import de.scholle.dummy.manager.DummyManager;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Dummy
extends JavaPlugin {
    private DummyManager dummyManager;
    private Language language;

    public void onEnable() {
        this.saveDefaultConfig();
        this.language = new Language(this);
        this.language.loadLanguageFiles();
        this.getConfig().addDefault("general.dummy-duration", (Object)30);
        this.getConfig().addDefault("general.drop-items", (Object)true);
        this.getConfig().addDefault("general.allow-projectiles", (Object)true);
        this.getConfig().addDefault("appearance.use-player-skin", (Object)true);
        this.getConfig().addDefault("appearance.show-equipment", (Object)true);
        this.getConfig().addDefault("npc-behavior.look-at-players", (Object)true);
        this.getConfig().addDefault("npc-behavior.can-move", (Object)false);
        this.getConfig().addDefault("npc-behavior.can-attack", (Object)false);
        this.getConfig().addDefault("npc-behavior.imitate-player", (Object)false);
        this.getConfig().addDefault("debug.enabled", (Object)false);
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.dummyManager = new DummyManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new DummyListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DummyJoinListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DummyQuitListener(this), (Plugin)this);
        this.dummyManager.start();
        this.getLogger().info("[LogoutDummy] Plugin aktiviert.");
        if (this.getConfig().getBoolean("debug.enabled")) {
            this.getLogger().info("[LogoutDummy] Debug-Modus aktiviert.");
        }
    }

    public void onDisable() {
        if (this.dummyManager != null) {
            this.dummyManager.stop();
        }
        this.getLogger().info("[LogoutDummy] Plugin deaktiviert.");
    }

    public DummyManager dummies() {
        return this.dummyManager;
    }

    public int getDummyDuration() {
        return this.getConfig().getInt("general.dummy-duration", 15);
    }

    public boolean shouldDropItems() {
        return this.getConfig().getBoolean("general.drop-items", true);
    }

    public boolean allowProjectiles() {
        return this.getConfig().getBoolean("general.allow-projectiles", true);
    }

    public boolean usePlayerSkin() {
        return this.getConfig().getBoolean("appearance.use-player-skin", true);
    }

    public boolean showEquipment() {
        return this.getConfig().getBoolean("appearance.show-equipment", true);
    }

    public String getKillBroadcast() {
        return this.language.getMessage("messages.kill-broadcast", "\u00a7f[\u00a76\u00a7lDummy\u00a7f] \u00a7c{player} \u00a7fwurde von \u00a7a{killer} \u00a7fals Offline-Dummy besiegt.");
    }

    public boolean isDebugEnabled() {
        return this.getConfig().getBoolean("debug.enabled", false);
    }
}

