/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.dummy;

import java.io.File;
import java.util.Locale;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Language {
    private final JavaPlugin plugin;
    private FileConfiguration langConfig;

    public Language(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadLanguageFiles() {
        String locale = Locale.getDefault().toString().toLowerCase();
        File languageFile = new File(this.plugin.getDataFolder(), "lang/" + locale + ".json");
        if (!languageFile.exists()) {
            languageFile = new File(this.plugin.getDataFolder(), "lang/en_us.json");
        }
        this.langConfig = YamlConfiguration.loadConfiguration((File)languageFile);
    }

    public String getMessage(String path, String defaultMessage) {
        if (this.langConfig == null) {
            return defaultMessage;
        }
        return this.langConfig.getString(path, defaultMessage);
    }
}

