/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.dummy.manager;

import de.oliver.fancynpcs.api.FancyNpcsPlugin;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcData;
import de.scholle.dummy.Dummy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

public class DummyManager
implements Listener {
    private final Dummy plugin;
    private final MiniMessage MM = MiniMessage.miniMessage();
    private final Map<UUID, DummyData> active = new HashMap<UUID, DummyData>();
    private final Map<String, UUID> byNpcName = new HashMap<String, UUID>();
    private final Set<UUID> pendingDeath = new HashSet<UUID>();
    private final Set<UUID> suppressSpawnOnce = new HashSet<UUID>();
    private BukkitTask ticker;
    private Listener deathFilterListener;

    public DummyManager(Dummy plugin) {
        this.plugin = plugin;
    }

    public void start() {
        this.stop();
        this.deathFilterListener = new Listener(){

            @EventHandler
            public void onDeath(PlayerDeathEvent e) {
                UUID uid = e.getEntity().getUniqueId();
                if (!DummyManager.this.pendingDeath.contains(uid)) {
                    return;
                }
                try {
                    e.deathMessage((Component)null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                e.getDrops().clear();
                e.setShouldDropExperience(false);
                e.setDroppedExp(0);
            }
        };
        this.plugin.getServer().getPluginManager().registerEvents(this.deathFilterListener, (Plugin)this.plugin);
        this.ticker = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            long now = System.currentTimeMillis();
            Iterator<Map.Entry<UUID, DummyData>> it = this.active.entrySet().iterator();
            while (it.hasNext()) {
                DummyData d = it.next().getValue();
                long secs = Math.max(0L, (d.expiresAt - now) / 1000L);
                try {
                    d.npc.getData().setDisplayName(this.mmTitle(d.ownerName, d.health, d.maxHealth, secs));
                    d.npc.updateForAll();
                    this.calmNpc(d.npc, d.location);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (now < d.expiresAt) continue;
                this.removeNpc(d);
                it.remove();
            }
        }, 5L, 5L);
    }

    public void stop() {
        if (this.ticker != null) {
            this.ticker.cancel();
            this.ticker = null;
        }
        for (UUID u : new ArrayList<UUID>(this.active.keySet())) {
            DummyData d = this.active.remove(u);
            if (d == null) continue;
            this.removeNpc(d);
        }
        this.byNpcName.clear();
        this.pendingDeath.clear();
        this.suppressSpawnOnce.clear();
        if (this.deathFilterListener != null) {
            HandlerList.unregisterAll((Listener)this.deathFilterListener);
            this.deathFilterListener = null;
        }
    }

    public void onDummyHit(ArmorStand ignored, Player damager) {
    }

    public void suppressSpawn(UUID id) {
        this.suppressSpawnOnce.add(id);
    }

    public void markPendingDeath(UUID id) {
        this.pendingDeath.add(id);
    }

    public void onNpcLeftClick(Npc npc, Player damager) {
        double damage;
        double afterArmor;
        DummyData d = this.findByNpc(npc);
        if (d == null || damager == null) {
            return;
        }
        d.expiresAt = System.currentTimeMillis() + (long)this.plugin.getDummyDuration() * 1000L;
        World w = d.location.getWorld();
        if (w != null) {
            w.playSound(d.location, Sound.ENTITY_PLAYER_HURT, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        if ((afterArmor = DummyManager.applyArmorReduction(damage = DummyManager.approximateDamage(damager), d.armorPoints, d.toughness)) <= 0.0) {
            afterArmor = 0.5;
        }
        DummyData dummy = d;
        dummy.health -= afterArmor;
        if (d.health <= 1.0E-4) {
            this.killDummy(d, damager);
        }
    }

    public void spawnOnLogout(Player p) {
        try {
            UUID id = p.getUniqueId();
            if (this.suppressSpawnOnce.remove(id)) {
                return;
            }
            this.createFor(p);
        }
        catch (Exception ex) {
            this.plugin.getLogger().warning("[Dummy] Spawn fehlgeschlagen: " + ex.getMessage());
        }
    }

    public void handleJoin(Player p) {
        UUID id = p.getUniqueId();
        if (!this.pendingDeath.remove(id)) {
            return;
        }
        try {
            p.getInventory().clear();
            p.getInventory().setArmorContents(new ItemStack[4]);
            p.getInventory().setItemInOffHand((ItemStack)null);
            p.updateInventory();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> p.setHealth(0.0));
    }

    public boolean hasPendingDeath(UUID id) {
        return this.pendingDeath.contains(id);
    }

    private Location snapToGround(Location src) {
        int y;
        if (src == null || src.getWorld() == null) {
            return src;
        }
        World w = src.getWorld();
        int minY = w.getMinHeight();
        int startY = y = Math.min(w.getMaxHeight() - 1, Math.max(minY + 1, src.getBlockY()));
        while (y > minY + 1) {
            Material below = w.getBlockAt(src.getBlockX(), y - 1, src.getBlockZ()).getType();
            if (!below.isAir()) {
                return new Location(w, src.getX(), (double)y + 0.01, src.getZ(), src.getYaw(), 0.0f);
            }
            --y;
        }
        int hy = w.getHighestBlockYAt(src);
        return new Location(w, src.getX(), (double)hy + 0.01, src.getZ(), src.getYaw(), 0.0f);
    }

    private void createFor(Player p) {
        Location loc = p.getLocation().clone();
        loc.setPitch(0.0f);
        loc = this.snapToGround(loc);
        double max = 20.0;
        try {
            AttributeInstance attr = p.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (attr != null) {
                max = Math.max(1.0, attr.getValue());
            }
        }
        catch (Throwable attr) {
            // empty catch block
        }
        double cur = Math.max(0.5, Math.min(max, p.getHealth()));
        PlayerInventory inv = p.getInventory();
        ItemStack[] storage = DummyManager.cloneArray(inv.getStorageContents());
        ItemStack[] armor = DummyManager.cloneArray(inv.getArmorContents());
        ItemStack offhand = DummyManager.safeClone(inv.getItemInOffHand());
        ItemStack mainHand = DummyManager.safeClone(inv.getItemInMainHand());
        ArmorStats stats = DummyManager.calcArmorStats(armor);
        String npcName = "dummy_" + p.getUniqueId().toString().substring(0, 8);
        NpcData data = new NpcData(npcName, p.getUniqueId(), loc);
        if (this.plugin.usePlayerSkin()) {
            data.setSkin(p.getUniqueId().toString());
        }
        data.setDisplayName(this.mmTitle(p.getName(), cur, max, this.plugin.getDummyDuration()));
        Npc npc = (Npc)FancyNpcsPlugin.get().getNpcAdapter().apply(data);
        npc.setSaveToFile(false);
        FancyNpcsPlugin.get().getNpcManager().registerNpc(npc);
        npc.create();
        npc.spawnForAll();
        this.freezeNpc(npc, loc);
        if (this.plugin.showEquipment()) {
            this.applyVisualEquipmentSafe(npc, armor, mainHand, offhand);
        }
        DummyData d = new DummyData(p.getUniqueId(), p.getName(), npc, loc, cur, max, storage, armor, offhand, mainHand, stats.armorPoints, stats.toughness);
        d.expiresAt = System.currentTimeMillis() + (long)this.plugin.getDummyDuration() * 1000L;
        this.active.put(p.getUniqueId(), d);
        this.byNpcName.put(npcName, p.getUniqueId());
        if (this.plugin.isDebugEnabled()) {
            this.plugin.getLogger().info("[Dummy] Dummy erstellt f\u00fcr " + p.getName() + " f\u00fcr " + this.plugin.getDummyDuration() + " Sekunden");
        }
    }

    private void killDummy(DummyData d, Player killer) {
        if (this.plugin.shouldDropItems()) {
            this.dropOnce(d);
        }
        this.removeNpc(d);
        this.active.remove(d.owner);
        String k = killer != null ? killer.getName() : "unbekannt";
        String broadcastMsg = this.plugin.getKillBroadcast().replace("{player}", d.ownerName).replace("{killer}", k);
        Bukkit.getServer().broadcast((Component)Component.text((String)broadcastMsg));
        this.pendingDeath.add(d.owner);
        if (this.plugin.isDebugEnabled()) {
            this.plugin.getLogger().info("[Dummy] Dummy von " + d.ownerName + " wurde von " + k + " besiegt");
        }
    }

    private void removeNpc(DummyData d) {
        try {
            d.npc.removeForAll();
            FancyNpcsPlugin.get().getNpcManager().removeNpc(d.npc);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.byNpcName.values().removeIf(u -> u.equals(d.owner));
        if (this.plugin.isDebugEnabled()) {
            this.plugin.getLogger().info("[Dummy] Dummy von " + d.ownerName + " entfernt");
        }
    }

    private void dropOnce(DummyData d) {
        if (d.dropped) {
            return;
        }
        d.dropped = true;
        World w = d.location.getWorld();
        if (w == null) {
            return;
        }
        for (ItemStack is : d.storage) {
            this.drop(w, d.location, is);
        }
        for (ItemStack is : d.armor) {
            this.drop(w, d.location, is);
        }
        this.drop(w, d.location, d.offhand);
    }

    private void drop(World w, Location at, ItemStack is) {
        if (is == null || is.getType() == Material.AIR) {
            return;
        }
        w.dropItemNaturally(at, is.clone());
    }

    private DummyData findByNpc(Npc npc) {
        try {
            String name = npc.getData().getName();
            UUID owner = this.byNpcName.get(name);
            if (owner != null) {
                return this.active.get(owner);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (DummyData d : this.active.values()) {
            if (d.npc != npc) continue;
            return d;
        }
        return null;
    }

    private String mmTitle(String playerName, double health, double max, long secs) {
        return "<red>Offline</red> <gray>|</gray> <gold><bold>" + playerName + "</bold></gold> <gray>|</gray> " + this.heartBarMini(health, max) + " <gray>(" + secs + "s)</gray>";
    }

    private String heartBarMini(double hp, double max) {
        int total = Math.max(1, (int)Math.round(max / 2.0));
        int full = (int)Math.floor(hp / 2.0);
        boolean half = hp % 2.0 >= 1.0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < full; ++i) {
            sb.append("<red>\u2764</red>");
        }
        if (half) {
            sb.append("<gold>\u2764</gold>");
        }
        while (this.countHearts(sb) < total) {
            sb.append("<gray>\u2764</gray>");
        }
        return sb.toString();
    }

    private int countHearts(CharSequence s) {
        int c = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\u2764') continue;
            ++c;
        }
        return c;
    }

    private void freezeNpc(Npc npc, Location loc) {
        if (npc == null) {
            return;
        }
        try {
            NpcData data = npc.getData();
            this.callFlag(data, "setCanMove", this.plugin.getConfig().getBoolean("npc-behavior.can-move", false));
            this.callFlag(data, "setWalking", false);
            this.callFlag(data, "setWalk", false);
            this.callFlag(data, "setSprint", false);
            this.callFlag(data, "setRunning", false);
            this.callFlag(data, "setJumping", false);
            this.callFlag(data, "setGliding", false);
            this.callFlag(data, "setSwimming", false);
            this.callFlag(data, "setAttackAnimation", this.plugin.getConfig().getBoolean("npc-behavior.can-attack", false));
            this.callFlag(data, "setAttacking", this.plugin.getConfig().getBoolean("npc-behavior.can-attack", false));
            this.callFlag(data, "setAttack", this.plugin.getConfig().getBoolean("npc-behavior.can-attack", false));
            this.callFlag(data, "setSwinging", false);
            this.callFlag(data, "setLeftClicking", false);
            this.callFlag(data, "setHandAnimation", false);
            this.callFlag(data, "setUseItem", false);
            this.callFlag(data, "setAttackable", false);
            this.callFlag(data, "setImitatePlayer", this.plugin.getConfig().getBoolean("npc-behavior.imitate-player", false));
            this.callFlag(data, "setTurnToPlayer", this.plugin.getConfig().getBoolean("npc-behavior.look-at-players", true));
            this.callFlag(data, "setLookAtPlayer", this.plugin.getConfig().getBoolean("npc-behavior.look-at-players", true));
            try {
                Object standing;
                Method m = null;
                Class poseEnum = Arrays.stream(data.getClass().getMethods()).filter(method -> method.getName().equals("setPose") && method.getParameterCount() == 1).map(method -> method.getParameterTypes()[0]).findFirst().orElse(null);
                if (poseEnum != null && poseEnum.isEnum() && (standing = Arrays.stream(poseEnum.getEnumConstants()).filter(ec -> ec.toString().equalsIgnoreCase("STANDING") || ec.toString().equalsIgnoreCase("STAND")).findFirst().orElse(null)) != null) {
                    m = data.getClass().getMethod("setPose", poseEnum);
                    m.invoke((Object)data, standing);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.callRotation(data, "setRotation", new Class[]{Float.TYPE, Float.TYPE}, new Object[]{Float.valueOf(loc.getYaw()), Float.valueOf(0.0f)});
            this.callRotation(data, "setYaw", new Class[]{Float.TYPE}, new Object[]{Float.valueOf(loc.getYaw())});
            this.callRotation(data, "setPitch", new Class[]{Float.TYPE}, new Object[]{Float.valueOf(0.0f)});
            npc.updateForAll();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void calmNpc(Npc npc, Location faceTowards) {
        if (npc == null) {
            return;
        }
        try {
            NpcData data = npc.getData();
            this.callFlag(data, "setAttackAnimation", false);
            this.callFlag(data, "setAttacking", false);
            this.callFlag(data, "setAttack", false);
            this.callFlag(data, "setSwinging", false);
            this.callFlag(data, "setLeftClicking", false);
            this.callFlag(data, "setUseItem", false);
            this.callFlag(data, "setHandAnimation", false);
            this.callFlag(data, "setImitatePlayer", this.plugin.getConfig().getBoolean("npc-behavior.imitate-player", false));
            this.callFlag(data, "setCanMove", this.plugin.getConfig().getBoolean("npc-behavior.can-move", false));
            this.callFlag(data, "setWalking", false);
            this.callFlag(data, "setWalk", false);
            this.callFlag(data, "setRunning", false);
            this.callFlag(data, "setSprint", false);
            this.callFlag(data, "setJumping", false);
            this.callFlag(data, "setGliding", false);
            this.callFlag(data, "setSwimming", false);
            this.callFlag(data, "setAttackable", false);
            this.callFlag(data, "setLookAtPlayer", this.plugin.getConfig().getBoolean("npc-behavior.look-at-players", true));
            this.callFlag(data, "setTurnToPlayer", this.plugin.getConfig().getBoolean("npc-behavior.look-at-players", true));
            if (faceTowards != null) {
                this.callRotation(data, "setRotation", new Class[]{Float.TYPE, Float.TYPE}, new Object[]{Float.valueOf(faceTowards.getYaw()), Float.valueOf(0.0f)});
                this.callRotation(data, "setYaw", new Class[]{Float.TYPE}, new Object[]{Float.valueOf(faceTowards.getYaw())});
                this.callRotation(data, "setPitch", new Class[]{Float.TYPE}, new Object[]{Float.valueOf(0.0f)});
            }
            npc.updateForAll();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void callFlag(Object target, String setter, boolean value) {
        try {
            target.getClass().getMethod(setter, Boolean.TYPE).invoke(target, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean callRotation(Object target, String name, Class<?>[] paramTypes, Object[] args) {
        try {
            Method m = target.getClass().getMethod(name, paramTypes);
            m.invoke(target, args);
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static double approximateDamage(Player attacker) {
        PotionEffect eff;
        boolean crit;
        ItemStack mh = attacker.getInventory().getItemInMainHand();
        Material t = mh != null ? mh.getType() : Material.AIR;
        double base = 0.0;
        switch (t) {
            case NETHERITE_SWORD: {
                base = 8.0;
                break;
            }
            case DIAMOND_SWORD: {
                base = 7.0;
                break;
            }
            case IRON_SWORD: {
                base = 6.0;
                break;
            }
            case STONE_SWORD: {
                base = 5.0;
                break;
            }
            case GOLDEN_SWORD: 
            case WOODEN_SWORD: {
                base = 4.0;
                break;
            }
            case NETHERITE_AXE: {
                base = 10.0;
                break;
            }
            case DIAMOND_AXE: {
                base = 9.0;
                break;
            }
            case IRON_AXE: 
            case STONE_AXE: {
                base = 9.0;
                break;
            }
            case GOLDEN_AXE: 
            case WOODEN_AXE: {
                base = 7.0;
                break;
            }
            default: {
                base = 3.0;
            }
        }
        boolean bl = crit = (double)attacker.getFallDistance() > 0.0 && !attacker.isSprinting() && !attacker.isClimbing() && !attacker.isInWater() && !attacker.isGliding();
        if (crit) {
            base *= 1.5;
        }
        if ((eff = attacker.getPotionEffect(PotionEffectType.INCREASE_DAMAGE)) != null) {
            base += 3.0 * (double)(eff.getAmplifier() + 1);
        }
        return Math.max(0.5, base);
    }

    private static double applyArmorReduction(double damage, int armorPoints, double toughness) {
        double base = Math.min(20.0, Math.max((double)armorPoints / 5.0, (double)armorPoints - damage / (2.0 + toughness / 4.0)));
        double multiplier = 1.0 - base / 25.0;
        return Math.max(0.0, damage * multiplier);
    }

    private static ArmorStats calcArmorStats(ItemStack[] armor) {
        ArmorStats s = new ArmorStats();
        if (armor == null) {
            return s;
        }
        block22: for (ItemStack piece : armor) {
            if (piece == null) continue;
            switch (piece.getType()) {
                case LEATHER_HELMET: {
                    ArmorStats armorStats = s;
                    ++armorStats.armorPoints;
                    continue block22;
                }
                case LEATHER_CHESTPLATE: {
                    ArmorStats armorStats2 = s;
                    armorStats2.armorPoints += 3;
                    continue block22;
                }
                case LEATHER_LEGGINGS: {
                    ArmorStats armorStats3 = s;
                    armorStats3.armorPoints += 2;
                    continue block22;
                }
                case LEATHER_BOOTS: {
                    ArmorStats armorStats4 = s;
                    ++armorStats4.armorPoints;
                    continue block22;
                }
                case GOLDEN_HELMET: 
                case CHAINMAIL_HELMET: {
                    ArmorStats armorStats5 = s;
                    armorStats5.armorPoints += 2;
                    continue block22;
                }
                case GOLDEN_CHESTPLATE: 
                case CHAINMAIL_CHESTPLATE: {
                    ArmorStats armorStats6 = s;
                    armorStats6.armorPoints += 5;
                    continue block22;
                }
                case GOLDEN_LEGGINGS: 
                case CHAINMAIL_LEGGINGS: {
                    ArmorStats armorStats7 = s;
                    armorStats7.armorPoints += 4;
                    continue block22;
                }
                case GOLDEN_BOOTS: 
                case CHAINMAIL_BOOTS: {
                    ArmorStats armorStats8 = s;
                    ++armorStats8.armorPoints;
                    continue block22;
                }
                case IRON_HELMET: {
                    ArmorStats armorStats9 = s;
                    armorStats9.armorPoints += 2;
                    continue block22;
                }
                case IRON_CHESTPLATE: {
                    ArmorStats armorStats10 = s;
                    armorStats10.armorPoints += 6;
                    continue block22;
                }
                case IRON_LEGGINGS: {
                    ArmorStats armorStats11 = s;
                    armorStats11.armorPoints += 5;
                    continue block22;
                }
                case IRON_BOOTS: {
                    ArmorStats armorStats12 = s;
                    armorStats12.armorPoints += 2;
                    continue block22;
                }
                case DIAMOND_HELMET: {
                    ArmorStats armorStats13 = s;
                    armorStats13.armorPoints += 3;
                    ArmorStats armorStats14 = s;
                    armorStats14.toughness += 2.0;
                    continue block22;
                }
                case DIAMOND_CHESTPLATE: {
                    ArmorStats armorStats15 = s;
                    armorStats15.armorPoints += 8;
                    ArmorStats armorStats16 = s;
                    armorStats16.toughness += 2.0;
                    continue block22;
                }
                case DIAMOND_LEGGINGS: {
                    ArmorStats armorStats17 = s;
                    armorStats17.armorPoints += 6;
                    ArmorStats armorStats18 = s;
                    armorStats18.toughness += 2.0;
                    continue block22;
                }
                case DIAMOND_BOOTS: {
                    ArmorStats armorStats19 = s;
                    armorStats19.armorPoints += 3;
                    ArmorStats armorStats20 = s;
                    armorStats20.toughness += 2.0;
                    continue block22;
                }
                case NETHERITE_HELMET: {
                    ArmorStats armorStats21 = s;
                    armorStats21.armorPoints += 3;
                    ArmorStats armorStats22 = s;
                    armorStats22.toughness += 3.0;
                    continue block22;
                }
                case NETHERITE_CHESTPLATE: {
                    ArmorStats armorStats23 = s;
                    armorStats23.armorPoints += 8;
                    ArmorStats armorStats24 = s;
                    armorStats24.toughness += 3.0;
                    continue block22;
                }
                case NETHERITE_LEGGINGS: {
                    ArmorStats armorStats25 = s;
                    armorStats25.armorPoints += 6;
                    ArmorStats armorStats26 = s;
                    armorStats26.toughness += 3.0;
                    continue block22;
                }
                case NETHERITE_BOOTS: {
                    ArmorStats armorStats27 = s;
                    armorStats27.armorPoints += 3;
                    ArmorStats armorStats28 = s;
                    armorStats28.toughness += 3.0;
                    continue block22;
                }
            }
        }
        return s;
    }

    private void applyVisualEquipmentSafe(Npc npc, ItemStack[] armor, ItemStack mainHand, ItemStack offhand) {
        try {
            NpcData data = npc.getData();
            try {
                Method mGetEq = data.getClass().getMethod("getEquipment", new Class[0]);
                Object eq = mGetEq.invoke((Object)data, new Object[0]);
                boolean changed = false;
                changed |= this.setEqB(eq, "setHelmet", this.getArmor(armor, EquipmentSlot.HEAD));
                changed |= this.setEqB(eq, "setChestplate", this.getArmor(armor, EquipmentSlot.CHEST));
                changed |= this.setEqB(eq, "setLeggings", this.getArmor(armor, EquipmentSlot.LEGS));
                changed |= this.setEqB(eq, "setBoots", this.getArmor(armor, EquipmentSlot.FEET));
                changed |= this.setEqB(eq, "setHand", mainHand) | this.setEqB(eq, "setMainHand", mainHand);
                changed |= this.setEqB(eq, "setOffhand", offhand) | this.setEqB(eq, "setOffHand", offhand);
                try {
                    Method mSet = data.getClass().getMethod("setEquipment", eq.getClass());
                    mSet.invoke((Object)data, eq);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (changed) {
                    npc.updateForAll();
                }
            }
            catch (NoSuchMethodException ex) {
                boolean changed2 = false;
                changed2 |= this.callIfPresentB(data, "setHelmet", ItemStack.class, this.getArmor(armor, EquipmentSlot.HEAD));
                changed2 |= this.callIfPresentB(data, "setChestplate", ItemStack.class, this.getArmor(armor, EquipmentSlot.CHEST));
                changed2 |= this.callIfPresentB(data, "setLeggings", ItemStack.class, this.getArmor(armor, EquipmentSlot.LEGS));
                changed2 |= this.callIfPresentB(data, "setBoots", ItemStack.class, this.getArmor(armor, EquipmentSlot.FEET));
                changed2 |= this.callIfPresentB(data, "setMainHand", ItemStack.class, mainHand) | this.callIfPresentB(data, "setHand", ItemStack.class, mainHand);
                if (changed2 |= this.callIfPresentB(data, "setOffHand", ItemStack.class, offhand) | this.callIfPresentB(data, "setOffhand", ItemStack.class, offhand)) {
                    npc.updateForAll();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean setEqB(Object eq, String method, ItemStack item) {
        try {
            Method m = eq.getClass().getMethod(method, ItemStack.class);
            m.invoke(eq, item == null || item.getType() == Material.AIR ? null : item.clone());
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private boolean callIfPresentB(Object target, String name, Class<?> param, Object arg) {
        try {
            ItemStack is;
            Method m = target.getClass().getMethod(name, param);
            if (arg instanceof ItemStack && (is = (ItemStack)arg).getType() == Material.AIR) {
                arg = null;
            }
            m.invoke(target, arg);
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private ItemStack getArmor(ItemStack[] armor, EquipmentSlot slot) {
        if (armor == null) {
            return null;
        }
        return switch (slot) {
            case EquipmentSlot.FEET -> {
                if (armor.length > 0) {
                    yield armor[0];
                }
                yield null;
            }
            case EquipmentSlot.LEGS -> {
                if (armor.length > 1) {
                    yield armor[1];
                }
                yield null;
            }
            case EquipmentSlot.CHEST -> {
                if (armor.length > 2) {
                    yield armor[2];
                }
                yield null;
            }
            case EquipmentSlot.HEAD -> {
                if (armor.length > 3) {
                    yield armor[3];
                }
                yield null;
            }
            default -> null;
        };
    }

    private static ItemStack[] cloneArray(ItemStack[] src) {
        if (src == null) {
            return new ItemStack[0];
        }
        ItemStack[] out = new ItemStack[src.length];
        for (int i = 0; i < src.length; ++i) {
            out[i] = DummyManager.safeClone(src[i]);
        }
        return out;
    }

    private static ItemStack safeClone(ItemStack is) {
        return is == null || is.getType() == Material.AIR ? null : is.clone();
    }

    private static class DummyData {
        final UUID owner;
        final String ownerName;
        final Npc npc;
        final Location location;
        double health;
        double maxHealth;
        final ItemStack[] storage;
        final ItemStack[] armor;
        final ItemStack offhand;
        final ItemStack mainHand;
        final int armorPoints;
        final double toughness;
        long expiresAt;
        boolean dropped = false;

        DummyData(UUID owner, String ownerName, Npc npc, Location location, double health, double maxHealth, ItemStack[] storage, ItemStack[] armor, ItemStack offhand, ItemStack mainHand, int armorPoints, double toughness) {
            this.owner = owner;
            this.ownerName = ownerName;
            this.npc = npc;
            this.location = location;
            this.health = health;
            this.maxHealth = maxHealth;
            this.storage = storage;
            this.armor = armor;
            this.offhand = offhand;
            this.mainHand = mainHand;
            this.armorPoints = armorPoints;
            this.toughness = toughness;
        }
    }

    private static class ArmorStats {
        int armorPoints;
        double toughness;

        private ArmorStats() {
        }
    }
}

