/*
 * Decompiled with CFR 0.152.
 */
package me.TreeOfSelf.PandaBlockName;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class PandaBlockNameConfig {
    private static final File CONFIG_FILE = new File("./config/PandaBlockName.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, Boolean> FEATURES = new HashMap<String, Boolean>(){
        {
            this.put("Block", true);
            this.put("Crafting", true);
            this.put("Enderman", true);
            this.put("Vegetation", true);
            this.put("BambooGrowth", true);
            this.put("CactusGrowth", true);
            this.put("SugarCaneGrowth", true);
            this.put("SaplingGrowth", true);
            this.put("StemGrowth", true);
            this.put("StemPlantGrowth", true);
            this.put("SeaPickleGrowth", true);
            this.put("VineGrowth", true);
            this.put("ChorusFlowerGrowth", true);
            this.put("PumpkinShearing", true);
            this.put("GlowBerryPicking", true);
            this.put("SweetBerryPicking", true);
            this.put("MushroomGrowth", true);
            this.put("HugeBrownMushroomGeneration", true);
            this.put("HugeRedMushroomGeneration", true);
            this.put("HugeMushroomFeatures", true);
            this.put("HugeFungusGeneration", true);
        }
    };

    public static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                JsonObject updatedJson = new JsonObject();
                for (String feature : FEATURES.keySet()) {
                    boolean value;
                    if (json.has(feature)) {
                        value = json.get(feature).getAsBoolean();
                        FEATURES.put(feature, value);
                    } else {
                        value = FEATURES.get(feature);
                    }
                    updatedJson.addProperty(feature, Boolean.valueOf(value));
                }
                PandaBlockNameConfig.saveConfigToFile(updatedJson);
            }
            catch (IOException iOException) {}
        } else {
            PandaBlockNameConfig.createDefaultConfig();
        }
    }

    private static void createDefaultConfig() {
        JsonObject json = new JsonObject();
        FEATURES.forEach((feature, defaultValue) -> json.addProperty(feature, defaultValue));
        PandaBlockNameConfig.saveConfigToFile(json);
    }

    private static void saveConfigToFile(JsonObject json) {
        try {
            if (!CONFIG_FILE.getParentFile().exists()) {
                CONFIG_FILE.getParentFile().mkdirs();
            }
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isFeatureEnabled(String feature) {
        return FEATURES.getOrDefault(feature, false);
    }

    public static boolean isVegetationFeatureEnabled(String feature) {
        return PandaBlockNameConfig.isFeatureEnabled("Vegetation") && PandaBlockNameConfig.isFeatureEnabled(feature);
    }
}

