/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.blocks;

import io.github.fetzi.blocks.RotatableBlock;
import io.github.fetzi.entity.custom.HorizontalWallHolderBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HorizontalWallHolder
extends RotatableBlock
implements EntityBlock {
    private static VoxelShape SHAPE_N = HorizontalWallHolder.makeShape_N();
    private static VoxelShape SHAPE_E = HorizontalWallHolder.makeShape_E();
    private static VoxelShape SHAPE_S = HorizontalWallHolder.makeShape_S();
    private static VoxelShape SHAPE_W = HorizontalWallHolder.makeShape_W();
    public static final BooleanProperty PLAQUE = BooleanProperty.m_61465_((String)"plaque");

    public HorizontalWallHolder(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)PLAQUE, (Comparable)Boolean.valueOf(false)));
    }

    public static VoxelShape makeShape_N() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.4125, (double)0.018750000000000044, (double)0.875, (double)0.5, (double)0.14375000000000004), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape makeShape_E() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.85625, (double)0.4125, (double)0.125, (double)0.98125, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape makeShape_S() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.4125, (double)0.85625, (double)0.875, (double)0.5, (double)0.98125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape makeShape_W() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.018750000000000044, (double)0.4125, (double)0.125, (double)0.14375000000000004, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        VoxelShape returnShape = Shapes.m_83040_();
        switch (direction) {
            case NORTH: {
                returnShape = SHAPE_N;
                break;
            }
            case EAST: {
                returnShape = SHAPE_E;
                break;
            }
            case SOUTH: {
                returnShape = SHAPE_S;
                break;
            }
            case WEST: {
                returnShape = SHAPE_W;
            }
        }
        return returnShape;
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        VoxelShape returnShape = Shapes.m_83040_();
        switch (direction) {
            case NORTH: {
                returnShape = SHAPE_N;
                break;
            }
            case EAST: {
                returnShape = SHAPE_E;
                break;
            }
            case SOUTH: {
                returnShape = SHAPE_S;
                break;
            }
            case WEST: {
                returnShape = SHAPE_W;
            }
        }
        return returnShape;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        HorizontalWallHolderBlockEntity blockEntity;
        if (player.m_5833_()) {
            return InteractionResult.PASS;
        }
        if (!((Boolean)state.m_61143_((Property)PLAQUE)).booleanValue() && player.m_21120_(InteractionHand.MAIN_HAND).m_150930_(Items.f_42417_)) {
            Optional<BlockState> newState = HorizontalWallHolder.addPlaque(state, world, pos, player, hand, hit);
            if (newState.isPresent()) {
                world.m_7731_(pos, newState.get(), 3);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (!world.m_5776_() && (blockEntity = (HorizontalWallHolderBlockEntity)world.m_7702_(pos)) != null) {
            player.m_5893_((MenuProvider)blockEntity);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public static Optional<BlockState> addPlaque(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack item;
        if (player.m_150110_().f_35938_ && hand == InteractionHand.MAIN_HAND && (item = player.m_21120_(InteractionHand.MAIN_HAND)).m_150930_(Items.f_42417_)) {
            if (!player.m_7500_()) {
                item.m_41774_(1);
            }
            world.m_5594_(null, pos, SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, (world.m_213780_().m_188501_() - world.m_213780_().m_188501_()) * 0.2f + 1.0f);
            state = (BlockState)state.m_61124_((Property)PLAQUE, (Comparable)Boolean.valueOf(true));
            return Optional.of(state);
        }
        return Optional.empty();
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.fetzisdisplays.shift_2"));
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltip.horizontal_wall_holder.1"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.horizontal_wall_holder.2"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.fetzisdisplays.shift_1"));
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tileentity = world.m_7702_(pos);
            if (tileentity instanceof HorizontalWallHolderBlockEntity) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((HorizontalWallHolderBlockEntity)tileentity));
                world.m_46672_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity ent, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.m_41788_() && (tileentity = world.m_7702_(pos)) instanceof HorizontalWallHolderBlockEntity) {
            ((HorizontalWallHolderBlockEntity)tileentity).m_58638_(stack.m_41611_());
        }
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction clicked = context.m_43719_();
        if (clicked.m_122434_().m_122479_()) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)clicked.m_122424_());
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos supportPos = pos.m_121945_(facing);
        return world.m_8055_(supportPos).m_60783_((BlockGetter)world, supportPos, facing.m_122424_());
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HorizontalWallHolderBlockEntity(pos, state);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{PLAQUE});
    }
}

