/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.compat.jei;

import io.github.fetzi.init.blockInit;
import io.github.fetzi.recipe.WorkbenchRecipe;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkbenchCategory
implements IRecipeCategory<WorkbenchRecipe> {
    private final IDrawable bg;
    private final IDrawable icon;
    private final Component title;
    public static final RecipeType<WorkbenchRecipe> WORKBENCH_RECIPE_TYPE = RecipeType.create((String)"fetzisdisplays", (String)"workbench_cutting", WorkbenchRecipe.class);

    public WorkbenchCategory(IGuiHelper helper) {
        this.bg = helper.createDrawable(new ResourceLocation("fetzisdisplays", "textures/gui/jei/workbench_jei_gui.png"), 4, 0, 82, 34);
        ItemStack workbenchStack = new ItemStack((ItemLike)blockInit.WORKBENCH.get());
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)workbenchStack);
        this.title = ((Block)blockInit.WORKBENCH.get()).m_49954_();
    }

    public RecipeType<WorkbenchRecipe> getRecipeType() {
        return WORKBENCH_RECIPE_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.bg;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WorkbenchRecipe recipe, IFocusGroup focuses) {
        List stacksWithCount = Arrays.stream(recipe.getIngredient().m_43908_()).map(stack -> {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(recipe.getAmount());
            return copy;
        }).collect(Collectors.toList());
        builder.addInputSlot(1, 9).setStandardSlotBackground().addItemStacks(stacksWithCount);
        assert (Minecraft.m_91087_().f_91073_ != null);
        builder.addOutputSlot(61, 9).setOutputSlotBackground().addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
    }
}

