/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.fetzi.blocks.GlassCloche;
import io.github.fetzi.entity.custom.GlassClocheBlockEntity;
import io.github.fetzi.network.PacketHandler;
import io.github.fetzi.network.SyncBlockEntityDataPacket;
import io.github.fetzi.util.FetzisDisplaysTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlassClocheBlockRenderer
implements BlockEntityRenderer<GlassClocheBlockEntity> {
    public GlassClocheBlockRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(GlassClocheBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean defaultValues = blockEntity.getDefaultValues();
        ItemStack items = (ItemStack)blockEntity.getItemsForRender().get(0);
        if (defaultValues && !items.m_41619_()) {
            Item item = items.m_41720_();
            CompoundTag tag = new CompoundTag();
            if (item instanceof PlayerHeadItem || items.m_204117_(FetzisDisplaysTags.Items.HEADS)) {
                tag.m_128405_("Scale", 75);
                tag.m_128379_("defaultValues", false);
            }
            PacketHandler.CHANNEL.sendToServer((Object)new SyncBlockEntityDataPacket(blockEntity.m_58899_(), tag));
        }
        Direction dir = (Direction)blockEntity.m_58900_().m_61143_((Property)GlassCloche.FACING);
        int xDegree = blockEntity.getXDegree();
        int zDegree = blockEntity.getZDegree();
        float scale = (float)blockEntity.getScale() / 100.0f;
        float y = (float)blockEntity.getY() / 100.0f;
        if (!items.m_41619_()) {
            double seconds = (double)System.nanoTime() * 1.0E-9;
            poseStack.m_85836_();
            if (items.m_41720_() instanceof PlayerHeadItem || items.m_204117_(FetzisDisplaysTags.Items.HEADS)) {
                Player playerNearby = blockEntity.m_58904_().m_45924_((double)blockEntity.m_58899_().m_123341_() + 0.5, (double)blockEntity.m_58899_().m_123342_() + 0.5, (double)blockEntity.m_58899_().m_123343_() + 0.5, 3.0, false);
                if (playerNearby != null) {
                    poseStack.m_252880_(0.5f, y, 0.5f);
                    double dx = playerNearby.m_20185_() - ((double)blockEntity.m_58899_().m_123341_() + 0.5);
                    double dy = playerNearby.m_20186_() + (double)playerNearby.m_20192_() - ((double)blockEntity.m_58899_().m_123342_() + 0.5);
                    double dz = playerNearby.m_20189_() - ((double)blockEntity.m_58899_().m_123343_() + 0.5);
                    float yaw = (float)Math.toDegrees(Math.atan2(dz, dx)) + 90.0f;
                    double dist = Math.sqrt(dx * dx + dz * dz);
                    float pitch = (float)Math.toDegrees(Math.atan2(dy, dist));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(-yaw));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
                } else {
                    float yOffset = 0.05f * (float)Math.sin(seconds * 2.0);
                    poseStack.m_252880_(0.5f, y + yOffset, 0.5f);
                    float rotationAngle = (float)(seconds * 80.0 % 360.0);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(rotationAngle));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_((float)zDegree));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_((float)xDegree));
                }
                poseStack.m_85841_(scale, scale, scale);
            } else {
                float yOffset = 0.05f * (float)Math.sin(seconds * 2.0);
                poseStack.m_252880_(0.5f, y + yOffset, 0.5f);
                float rotationAngle = (float)(seconds * 80.0 % 360.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rotationAngle));
                poseStack.m_252781_(Axis.f_252403_.m_252977_((float)zDegree));
                poseStack.m_252781_(Axis.f_252529_.m_252977_((float)xDegree));
                poseStack.m_85841_(scale, scale, scale);
            }
            Minecraft.m_91087_().m_91291_().m_269128_(items, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, blockEntity.m_58904_(), 1);
            poseStack.m_85849_();
        }
    }
}

