/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.fetzi.blocks.KatanaStand;
import io.github.fetzi.entity.custom.KatanaStandBlockEntity;
import io.github.fetzi.network.PacketHandler;
import io.github.fetzi.network.SyncBlockEntityDataPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KatanaStandBlockRenderer
implements BlockEntityRenderer<KatanaStandBlockEntity> {
    public KatanaStandBlockRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(KatanaStandBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean defaultValues = blockEntity.getDefaultValues();
        ItemStack items = (ItemStack)blockEntity.getItemsForRender().get(0);
        Direction dir = (Direction)blockEntity.m_58900_().m_61143_((Property)KatanaStand.FACING);
        if (defaultValues && !items.m_41619_()) {
            Item item = items.m_41720_();
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("yDegree", (int)(-dir.m_122435_() + 180.0f));
            tag.m_128379_("defaultValues", false);
            PacketHandler.CHANNEL.sendToServer((Object)new SyncBlockEntityDataPacket(blockEntity.m_58899_(), tag));
        }
        int zDegree = blockEntity.getZDegree();
        int xDegree = blockEntity.getXDegree();
        int yDegree = blockEntity.getYDegree();
        float scale = (float)blockEntity.getScale() / 100.0f;
        float y = (float)blockEntity.getY() / 100.0f;
        float xz = (float)blockEntity.getXZ() / 100.0f;
        float x = 0.5f;
        float z = 0.5f;
        switch (dir) {
            case NORTH: 
            case SOUTH: {
                x = xz;
                break;
            }
            case EAST: 
            case WEST: {
                z = xz;
            }
        }
        if (!items.m_41619_()) {
            poseStack.m_85836_();
            poseStack.m_252880_(x, y, z);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)yDegree));
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)zDegree));
            poseStack.m_252781_(Axis.f_252529_.m_252977_((float)xDegree));
            poseStack.m_85841_(scale, scale, scale);
            Minecraft.m_91087_().m_91291_().m_269128_(items, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, blockEntity.m_58904_(), 1);
            poseStack.m_85849_();
        }
    }
}

