/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.fetzi.blocks.HorizontalWallHolder;
import io.github.fetzi.entity.custom.VerticalWallHolderBlockEntity;
import io.github.fetzi.network.PacketHandler;
import io.github.fetzi.network.SyncBlockEntityDataPacket;
import io.github.fetzi.util.FetzisDisplaysTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.state.properties.Property;

public class VerticalWallHolderRenderer
implements BlockEntityRenderer<VerticalWallHolderBlockEntity> {
    public VerticalWallHolderRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(VerticalWallHolderBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean defaultValues = blockEntity.getDefaultValues();
        ItemStack items = (ItemStack)blockEntity.getItemsForRender().get(0);
        Direction dir = (Direction)blockEntity.m_58900_().m_61143_((Property)HorizontalWallHolder.FACING);
        if (defaultValues && !items.m_41619_()) {
            Item item = items.m_41720_();
            CompoundTag tag = new CompoundTag();
            if (item instanceof SwordItem) {
                tag.m_128405_("zDegree", 135);
                tag.m_128405_("xDegree", 0);
                tag.m_128405_("yDegree", (int)(-dir.m_122435_() + 180.0f));
                tag.m_128405_("Scale", 58);
                tag.m_128405_("Y", 42);
                tag.m_128405_("XZ", 50);
                tag.m_128379_("defaultValues", false);
            } else if (item instanceof BlockItem) {
                tag.m_128405_("zDegree", 0);
                tag.m_128405_("xDegree", 0);
                tag.m_128405_("yDegree", (int)(-dir.m_122435_()));
                tag.m_128405_("Scale", 68);
                tag.m_128405_("Y", 55);
                tag.m_128405_("XZ", 50);
                tag.m_128379_("defaultValues", false);
            } else {
                tag.m_128405_("zDegree", 45);
                tag.m_128405_("xDegree", 0);
                tag.m_128405_("yDegree", (int)(-dir.m_122435_() + 180.0f));
                tag.m_128405_("Scale", 46);
                tag.m_128405_("Y", 55);
                tag.m_128405_("XZ", 50);
                tag.m_128379_("defaultValues", false);
            }
            PacketHandler.CHANNEL.sendToServer((Object)new SyncBlockEntityDataPacket(blockEntity.m_58899_(), tag));
        }
        int zDegree = blockEntity.getZDegree();
        int xDegree = blockEntity.getXDegree();
        int yDegree = blockEntity.getYDegree();
        float scale = (float)blockEntity.getScale() / 100.0f;
        float y = (float)blockEntity.getY() / 100.0f;
        float xz = (float)blockEntity.getXZ() / 100.0f;
        float xF = 0.0f;
        float yF = 0.0f;
        float zF = 0.0f;
        float nameXF = 0.0f;
        float nameYF = 0.0f;
        float nameZF = 0.0f;
        if (!items.m_41619_()) {
            poseStack.m_85836_();
            if (items.m_41720_() instanceof SwordItem) {
                switch (dir) {
                    case NORTH: {
                        xF = xz;
                        yF = y;
                        zF = 0.12f;
                        break;
                    }
                    case EAST: {
                        xF = 0.88f;
                        yF = y;
                        zF = xz;
                        break;
                    }
                    case SOUTH: {
                        xF = xz;
                        yF = y;
                        zF = 0.88f;
                        break;
                    }
                    case WEST: {
                        xF = 0.12f;
                        yF = y;
                        zF = xz;
                    }
                }
            } else {
                switch (dir) {
                    case NORTH: {
                        xF = xz;
                        yF = y;
                        zF = 0.12f;
                        break;
                    }
                    case EAST: {
                        xF = 0.88f;
                        yF = y;
                        zF = xz;
                        break;
                    }
                    case SOUTH: {
                        xF = xz;
                        yF = y;
                        zF = 0.88f;
                        break;
                    }
                    case WEST: {
                        xF = 0.12f;
                        yF = y;
                        zF = xz;
                    }
                }
            }
            if (items.m_41720_() instanceof PlayerHeadItem || items.m_204117_(FetzisDisplaysTags.Items.HEADS)) {
                poseStack.m_252880_(xF, yF - 0.1f, zF);
            } else {
                poseStack.m_252880_(xF, yF, zF);
            }
            if (items.m_41720_() instanceof SwordItem) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)yDegree));
            } else if (items.m_41720_() instanceof BlockItem) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)yDegree));
            } else {
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)yDegree));
            }
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)zDegree));
            poseStack.m_252781_(Axis.f_252529_.m_252977_((float)xDegree));
            poseStack.m_85841_(scale, scale, scale);
            Minecraft.m_91087_().m_91291_().m_269128_(items, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, blockEntity.m_58904_(), 1);
            poseStack.m_85849_();
        }
        Boolean plaque = (Boolean)blockEntity.m_58900_().m_61143_((Property)HorizontalWallHolder.PLAQUE);
        if (Minecraft.m_91087_().f_91074_ != null && plaque.booleanValue() && !items.m_150930_(Items.f_41852_)) {
            String itemName = items.m_41786_().getString();
            poseStack.m_85836_();
            switch (dir) {
                case NORTH: {
                    nameZF = 0.1f;
                    nameXF = 0.5f;
                    break;
                }
                case EAST: {
                    nameZF = 0.5f;
                    nameXF = 0.9f;
                    break;
                }
                case SOUTH: {
                    nameZF = 0.9f;
                    nameXF = 0.5f;
                    break;
                }
                case WEST: {
                    nameZF = 0.5f;
                    nameXF = 0.1f;
                }
            }
            nameYF = 0.8125f;
            poseStack.m_252880_(nameXF, nameYF, nameZF);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-dir.m_122435_()));
            poseStack.m_85841_(-0.003f, -0.003f, 0.1f);
            String cutItemName = "";
            cutItemName = itemName.length() > 20 ? itemName.substring(0, 20) : itemName;
            int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(cutItemName);
            Minecraft.m_91087_().f_91062_.m_271703_(cutItemName, (float)(-textWidth) / 2.0f, 0.0f, 2366979, false, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, packedLight);
            poseStack.m_85849_();
        }
    }
}

