/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.items;

import dev.architectury.networking.NetworkChannel;
import dev.architectury.platform.Platform;
import io.github.fetzi.blocks.GlassCloche;
import io.github.fetzi.blocks.HorizontalWallHolder;
import io.github.fetzi.blocks.KatanaStand;
import io.github.fetzi.blocks.VerticalWallHolder;
import io.github.fetzi.entity.custom.GlassClocheBlockEntity;
import io.github.fetzi.entity.custom.HorizontalWallHolderBlockEntity;
import io.github.fetzi.entity.custom.KatanaStandBlockEntity;
import io.github.fetzi.entity.custom.VerticalWallHolderBlockEntity;
import io.github.fetzi.network.PacketHandler;
import io.github.fetzi.network.SyncTagPacket;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;

public class MagnifyingGlassItem
extends Item {
    public MagnifyingGlassItem(Item.Properties properties) {
        super(properties);
    }

    public static void firstUseCheck(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("first_use")) {
            tag.m_128379_("first_use", true);
            if (Platform.getEnv().equals((Object)Dist.CLIENT)) {
                try {
                    NetworkChannel channel = PacketHandler.CHANNEL;
                    Method m = channel.getClass().getMethod("sendToServer", Object.class);
                    m.invoke((Object)channel, new SyncTagPacket(tag.m_6426_()));
                    Minecraft.m_91087_().f_91074_.m_21008_(InteractionHand.MAIN_HAND, stack);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Player player = ctx.m_43723_();
        BlockState state = ctx.m_43725_().m_8055_(pos);
        ItemStack magnifying_glass = ctx.m_43722_();
        MagnifyingGlassItem.firstUseCheck(magnifying_glass);
        if (player.m_6047_() && state.m_60734_() instanceof GlassCloche) {
            CompoundTag tag = magnifying_glass.m_41784_();
            int scale = tag.m_128451_("scroll_scale");
            BlockEntity be = world.m_7702_(pos);
            if (!world.f_46443_ && be instanceof GlassClocheBlockEntity) {
                GlassClocheBlockEntity cloche = (GlassClocheBlockEntity)be;
                cloche.setScale(scale);
                cloche.m_6596_();
                world.m_5594_(null, pos, SoundEvents.f_144231_, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_6047_() && state.m_60734_() instanceof KatanaStand) {
            CompoundTag tag = magnifying_glass.m_41784_();
            int scale = tag.m_128451_("scroll_scale");
            BlockEntity be = world.m_7702_(pos);
            if (!world.f_46443_ && be instanceof KatanaStandBlockEntity) {
                KatanaStandBlockEntity kse = (KatanaStandBlockEntity)be;
                kse.setScale(scale);
                kse.m_6596_();
                world.m_5594_(null, pos, SoundEvents.f_144231_, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_6047_() && state.m_60734_() instanceof HorizontalWallHolder) {
            CompoundTag tag = magnifying_glass.m_41784_();
            int scale = tag.m_128451_("scroll_scale");
            BlockEntity be = world.m_7702_(pos);
            if (!world.f_46443_ && be instanceof HorizontalWallHolderBlockEntity) {
                HorizontalWallHolderBlockEntity hwhe = (HorizontalWallHolderBlockEntity)be;
                hwhe.setScale(scale);
                hwhe.m_6596_();
                world.m_5594_(null, pos, SoundEvents.f_144231_, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_6047_() && state.m_60734_() instanceof VerticalWallHolder) {
            CompoundTag tag = magnifying_glass.m_41784_();
            int scale = tag.m_128451_("scroll_scale");
            BlockEntity be = world.m_7702_(pos);
            if (!world.f_46443_ && be instanceof VerticalWallHolderBlockEntity) {
                VerticalWallHolderBlockEntity vwhe = (VerticalWallHolderBlockEntity)be;
                vwhe.setScale(scale);
                vwhe.m_6596_();
                world.m_5594_(null, pos, SoundEvents.f_144231_, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(ctx);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.fetzisdisplays.shift_2"));
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltip.magnifying_glass.2"));
            tooltip.add((Component)Component.m_237119_());
            if (stack.m_41782_() && stack.m_41783_().m_128441_("scroll_scale")) {
                int scale = stack.m_41783_().m_128451_("scroll_scale");
                tooltip.add((Component)Component.m_237110_((String)"tooltip.magnifying_glass.1", (Object[])new Object[]{scale}));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.fetzisdisplays.shift_1"));
        }
    }

    public static void adjustScrollScale(ItemStack stack, int delta) {
        CompoundTag tag = stack.m_41784_();
        int current = tag.m_128451_("scroll_scale");
        int next = (current + delta + 100) % 100;
        tag.m_128405_("scroll_scale", next);
    }
}

