/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.items;

import dev.architectury.networking.NetworkChannel;
import dev.architectury.platform.Platform;
import io.github.fetzi.blocks.GlassCloche;
import io.github.fetzi.blocks.HorizontalWallHolder;
import io.github.fetzi.blocks.KatanaStand;
import io.github.fetzi.blocks.VerticalWallHolder;
import io.github.fetzi.entity.custom.GlassClocheBlockEntity;
import io.github.fetzi.entity.custom.HorizontalWallHolderBlockEntity;
import io.github.fetzi.entity.custom.KatanaStandBlockEntity;
import io.github.fetzi.entity.custom.VerticalWallHolderBlockEntity;
import io.github.fetzi.network.PacketHandler;
import io.github.fetzi.network.SyncTagPacket;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;

public class ProtractorItem
extends Item {
    public ProtractorItem(Item.Properties properties) {
        super(properties);
    }

    public static void firstUseCheck(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("first_use")) {
            tag.m_128379_("first_use", true);
            if (!tag.m_128441_("scroll_mode")) {
                tag.m_128359_("scroll_mode", "zAxis");
            }
            if (Platform.getEnv().equals((Object)Dist.CLIENT)) {
                try {
                    NetworkChannel channel = PacketHandler.CHANNEL;
                    Method m = channel.getClass().getMethod("sendToServer", Object.class);
                    m.invoke((Object)channel, new SyncTagPacket(tag.m_6426_()));
                    Minecraft.m_91087_().f_91074_.m_21008_(InteractionHand.MAIN_HAND, stack);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Player player = ctx.m_43723_();
        BlockState state = ctx.m_43725_().m_8055_(pos);
        ItemStack protractor = ctx.m_43722_();
        ProtractorItem.firstUseCheck(protractor);
        if (player.m_6047_() && state.m_60734_() instanceof GlassCloche) {
            CompoundTag tag = protractor.m_41784_();
            int degree = tag.m_128451_("scroll_angle");
            String mode = tag.m_128461_("scroll_mode");
            BlockEntity be = world.m_7702_(pos);
            if (!world.f_46443_ && be instanceof GlassClocheBlockEntity) {
                GlassClocheBlockEntity cloche = (GlassClocheBlockEntity)be;
                if (mode.equals("zAxis")) {
                    cloche.setZDegree(degree);
                    cloche.m_6596_();
                } else if (mode.equals("xAxis")) {
                    cloche.setXDegree(degree);
                    cloche.m_6596_();
                }
                world.m_5594_(null, pos, SoundEvents.f_11667_, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_6047_() && state.m_60734_() instanceof KatanaStand) {
            CompoundTag tag = protractor.m_41784_();
            int degree = tag.m_128451_("scroll_angle");
            String mode = tag.m_128461_("scroll_mode");
            BlockEntity be = world.m_7702_(pos);
            if (!world.f_46443_ && be instanceof KatanaStandBlockEntity) {
                KatanaStandBlockEntity kse = (KatanaStandBlockEntity)be;
                if (mode.equals("zAxis")) {
                    kse.setZDegree(degree);
                    kse.m_6596_();
                } else if (mode.equals("xAxis")) {
                    kse.setXDegree(degree);
                    kse.m_6596_();
                } else if (mode.equals("yAxis")) {
                    kse.setYDegree(degree);
                    kse.m_6596_();
                }
                world.m_5594_(null, pos, SoundEvents.f_11667_, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_6047_() && state.m_60734_() instanceof HorizontalWallHolder) {
            CompoundTag tag = protractor.m_41784_();
            int degree = tag.m_128451_("scroll_angle");
            String mode = tag.m_128461_("scroll_mode");
            BlockEntity be = world.m_7702_(pos);
            if (!world.f_46443_ && be instanceof HorizontalWallHolderBlockEntity) {
                HorizontalWallHolderBlockEntity hwhe = (HorizontalWallHolderBlockEntity)be;
                if (mode.equals("zAxis")) {
                    hwhe.setZDegree(degree);
                    hwhe.m_6596_();
                } else if (mode.equals("xAxis")) {
                    hwhe.setXDegree(degree);
                    hwhe.m_6596_();
                } else if (mode.equals("yAxis")) {
                    hwhe.setYDegree(degree);
                    hwhe.m_6596_();
                }
                world.m_5594_(null, pos, SoundEvents.f_11667_, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_6047_() && state.m_60734_() instanceof VerticalWallHolder) {
            CompoundTag tag = protractor.m_41784_();
            int degree = tag.m_128451_("scroll_angle");
            String mode = tag.m_128461_("scroll_mode");
            BlockEntity be = world.m_7702_(pos);
            if (!world.f_46443_ && be instanceof VerticalWallHolderBlockEntity) {
                VerticalWallHolderBlockEntity vwhe = (VerticalWallHolderBlockEntity)be;
                if (mode.equals("zAxis")) {
                    vwhe.setZDegree(degree);
                    vwhe.m_6596_();
                } else if (mode.equals("xAxis")) {
                    vwhe.setXDegree(degree);
                    vwhe.m_6596_();
                } else if (mode.equals("yAxis")) {
                    vwhe.setYDegree(degree);
                    vwhe.m_6596_();
                }
                world.m_5594_(null, pos, SoundEvents.f_11667_, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(ctx);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.fetzisdisplays.shift_2"));
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltip.protractor.2"));
            tooltip.add((Component)Component.m_237119_());
            if (stack.m_41782_() && stack.m_41783_().m_128441_("scroll_mode")) {
                String mode = stack.m_41783_().m_128461_("scroll_mode");
                if (mode.equals("zAxis")) {
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.protractor.mode", (Object[])new Object[]{Component.m_237115_((String)"tooltip.protractor.zAxis")}));
                } else if (mode.equals("xAxis")) {
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.protractor.mode", (Object[])new Object[]{Component.m_237115_((String)"tooltip.protractor.xAxis")}));
                } else if (mode.equals("yAxis")) {
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.protractor.mode", (Object[])new Object[]{Component.m_237115_((String)"tooltip.protractor.yAxis")}));
                }
            }
            if (stack.m_41782_() && stack.m_41783_().m_128441_("scroll_angle")) {
                int angle = stack.m_41783_().m_128451_("scroll_angle");
                tooltip.add((Component)Component.m_237110_((String)"tooltip.protractor.1", (Object[])new Object[]{angle}));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.fetzisdisplays.shift_1"));
        }
    }

    public static void adjustScrollAngle(ItemStack stack, int delta) {
        CompoundTag tag = stack.m_41784_();
        int current = tag.m_128451_("scroll_angle");
        int next = (current + delta + 360) % 360;
        tag.m_128405_("scroll_angle", next);
    }
}

