/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.menu;

import com.google.common.collect.Lists;
import io.github.fetzi.entity.custom.WorkbenchBlockEntity;
import io.github.fetzi.init.blockInit;
import io.github.fetzi.init.menuInit;
import io.github.fetzi.recipe.WorkbenchRecipe;
import io.github.fetzi.recipe.WorkbenchRecipeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WorkbenchMenu
extends AbstractContainerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int RESULT_SLOT = 1;
    private static final int INV_START = 2;
    private static final int INV_END = 29;
    private static final int HOTBAR_START = 29;
    private static final int HOTBAR_END = 38;
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private List<WorkbenchRecipe> recipes = Lists.newArrayList();
    private ItemStack lastInput = ItemStack.f_41583_;
    private final Slot inputSlot;
    private final Slot resultSlot;
    private final Container container;
    private final ResultContainer resultContainer = new ResultContainer();
    private long lastSoundTime;
    private Runnable slotUpdateListener = () -> {};

    public WorkbenchMenu(int id, Inventory playerInv) {
        this(id, playerInv, ContainerLevelAccess.f_39287_);
    }

    public WorkbenchMenu(int id, Inventory playerInv, final ContainerLevelAccess access) {
        super((MenuType)menuInit.WORKBENCH_MENU.get(), id);
        this.access = access;
        this.level = playerInv.f_35978_.m_9236_();
        this.container = new SimpleContainer(1){

            public void m_6596_() {
                super.m_6596_();
                WorkbenchMenu.this.m_6199_((Container)this);
                WorkbenchMenu.this.slotUpdateListener.run();
            }
        };
        this.inputSlot = this.m_38897_(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                stack.m_41678_(player.m_9236_(), player, stack.m_41613_());
                WorkbenchMenu.this.resultContainer.m_58395_(player, List.of(WorkbenchMenu.this.inputSlot.m_7993_()));
                WorkbenchRecipe recipe = WorkbenchMenu.this.recipes.get(WorkbenchMenu.this.selectedRecipeIndex.m_6501_());
                WorkbenchMenu.this.inputSlot.m_6201_(recipe.getAmount());
                if (WorkbenchMenu.this.inputSlot.m_6657_()) {
                    this.refreshResult();
                }
                access.m_39292_((lvl, pos) -> {
                    long now = lvl.m_46467_();
                    if (WorkbenchMenu.this.lastSoundTime != now) {
                        lvl.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        WorkbenchMenu.this.lastSoundTime = now;
                    }
                });
                access.m_39292_((lvl, pos) -> {
                    BlockEntity be = lvl.m_7702_(pos);
                    if (be instanceof WorkbenchBlockEntity) {
                        WorkbenchBlockEntity wb = (WorkbenchBlockEntity)be;
                        wb.setInput(WorkbenchMenu.this.inputSlot.m_7993_());
                        wb.setResult(WorkbenchMenu.this.resultContainer.m_8020_(1));
                    }
                });
                super.m_142406_(player, stack);
            }

            private void refreshResult() {
                WorkbenchMenu.this.setupResultSlot();
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int hot = 0; hot < 9; ++hot) {
            this.m_38897_(new Slot((Container)playerInv, hot, 8 + hot * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public boolean m_6875_(Player player) {
        return WorkbenchMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)blockInit.WORKBENCH.get()));
    }

    public boolean m_6366_(Player player, int index) {
        if (this.isValidRecipeIndex(index)) {
            this.selectedRecipeIndex.m_6422_(index);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int idx) {
        return idx >= 0 && idx < this.recipes.size();
    }

    public void m_6199_(Container inv) {
        ItemStack in = this.inputSlot.m_7993_();
        if (!in.equals(this.lastInput)) {
            this.lastInput = in.m_41777_();
            this.recalcRecipes(inv, in);
        }
        this.access.m_39292_((lvl, pos) -> {
            BlockEntity be = lvl.m_7702_(pos);
            if (be instanceof WorkbenchBlockEntity) {
                WorkbenchBlockEntity wb = (WorkbenchBlockEntity)be;
                wb.setInput(this.inputSlot.m_7993_());
                wb.setResult(this.resultContainer.m_8020_(1));
            }
        });
    }

    private void recalcRecipes(Container inv, ItemStack in) {
        List all = this.level.m_7465_().m_44056_(WorkbenchRecipeType.INSTANCE, inv, this.level);
        int oldIndex = this.selectedRecipeIndex.m_6501_();
        ArrayList<WorkbenchRecipe> filtered = new ArrayList<WorkbenchRecipe>();
        for (WorkbenchRecipe r : all) {
            if (in.m_41613_() < r.getAmount()) continue;
            filtered.add(r);
        }
        this.recipes = filtered;
        if (filtered.isEmpty()) {
            this.selectedRecipeIndex.m_6422_(-1);
        } else if (oldIndex >= 0 && oldIndex < filtered.size()) {
            this.selectedRecipeIndex.m_6422_(oldIndex);
        } else {
            this.selectedRecipeIndex.m_6422_(Math.min(Math.max(oldIndex, 0), filtered.size() - 1));
        }
        this.setupResultSlot();
    }

    private void setupResultSlot() {
        if (this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            WorkbenchRecipe recipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            ItemStack out = recipe.m_5874_(this.container, this.level.m_9598_());
            this.resultContainer.m_6029_((Recipe)recipe);
            this.resultSlot.m_5852_(out);
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
        this.access.m_39292_((lvl, pos) -> {
            BlockEntity be = lvl.m_7702_(pos);
            if (be instanceof WorkbenchBlockEntity) {
                WorkbenchBlockEntity wb = (WorkbenchBlockEntity)be;
                wb.setInput(this.inputSlot.m_7993_());
                wb.setResult(this.resultSlot.m_7993_());
            }
        });
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack originalStack = slot.m_7993_();
        ItemStack resultCopy = originalStack.m_41777_();
        if (index == 1) {
            ItemStack out;
            WorkbenchRecipe recipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            int needed = recipe.getAmount();
            while (this.inputSlot.m_7993_().m_41613_() >= needed && this.m_38903_(out = recipe.m_5874_(this.container, this.level.m_9598_()), 2, 38, true)) {
                this.inputSlot.m_6201_(needed);
                slot.m_40234_(out, resultCopy);
            }
        } else if (index == 0) {
            if (!this.m_38903_(originalStack, 2, 38, true)) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(originalStack, resultCopy);
        } else if (index >= 2) {
            boolean validForWorkbench;
            SimpleContainer test = new SimpleContainer(new ItemStack[]{originalStack.m_41777_()});
            boolean bl = validForWorkbench = !this.level.m_7465_().m_44056_(WorkbenchRecipeType.INSTANCE, (Container)test, this.level).isEmpty();
            if (validForWorkbench ? !this.m_38903_(originalStack, 0, 1, false) : (index < 29 ? !this.m_38903_(originalStack, 29, 38, false) : !this.m_38903_(originalStack, 2, 29, false))) {
                return ItemStack.f_41583_;
            }
        }
        if (originalStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        this.m_38946_();
        return resultCopy;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.m_150411_(player, this.container);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((lvl, pos) -> {
            BlockEntity be = lvl.m_7702_(pos);
            if (be instanceof WorkbenchBlockEntity) {
                WorkbenchBlockEntity wb = (WorkbenchBlockEntity)be;
                wb.setInput(ItemStack.f_41583_);
                wb.setResult(ItemStack.f_41583_);
            }
        });
    }

    public List<WorkbenchRecipe> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }
}

