/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.network;

import dev.architectury.networking.NetworkManager;
import io.github.fetzi.entity.custom.GlassClocheBlockEntity;
import io.github.fetzi.entity.custom.HorizontalWallHolderBlockEntity;
import io.github.fetzi.entity.custom.KatanaStandBlockEntity;
import io.github.fetzi.entity.custom.VerticalWallHolderBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;

public class SyncBlockEntityDataPacket {
    private final BlockPos pos;
    private final CompoundTag tag;

    public SyncBlockEntityDataPacket(BlockPos pos, CompoundTag tag) {
        this.pos = pos;
        this.tag = tag;
    }

    public static SyncBlockEntityDataPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        CompoundTag tag = buf.m_130260_();
        return new SyncBlockEntityDataPacket(pos, tag);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130079_(this.tag);
    }

    public void handle(Supplier<NetworkManager.PacketContext> context) {
        context.get().queue(() -> {
            RandomizableContainerBlockEntity holder;
            ServerPlayer player = (ServerPlayer)((NetworkManager.PacketContext)context.get()).getPlayer();
            BlockEntity be = player.m_9236_().m_7702_(this.pos);
            if (be instanceof KatanaStandBlockEntity) {
                holder = (KatanaStandBlockEntity)be;
                if (this.tag.m_128441_("yDegree")) {
                    holder.setYDegree(this.tag.m_128451_("yDegree"));
                }
                if (this.tag.m_128441_("defaultValues")) {
                    holder.setDefaultValues(this.tag.m_128471_("defaultValues"));
                }
                holder.m_6596_();
                player.m_9236_().m_7260_(this.pos, be.m_58900_(), be.m_58900_(), 3);
            }
            if (be instanceof HorizontalWallHolderBlockEntity) {
                holder = (HorizontalWallHolderBlockEntity)be;
                if (this.tag.m_128441_("yDegree")) {
                    holder.setYDegree(this.tag.m_128451_("yDegree"));
                }
                if (this.tag.m_128441_("defaultValues")) {
                    holder.setDefaultValues(this.tag.m_128471_("defaultValues"));
                }
                holder.m_6596_();
                player.m_9236_().m_7260_(this.pos, be.m_58900_(), be.m_58900_(), 3);
            }
            if (be instanceof VerticalWallHolderBlockEntity) {
                holder = (VerticalWallHolderBlockEntity)be;
                if (this.tag.m_128441_("zDegree")) {
                    holder.setZDegree(this.tag.m_128451_("zDegree"));
                }
                if (this.tag.m_128441_("xDegree")) {
                    holder.setXDegree(this.tag.m_128451_("xDegree"));
                }
                if (this.tag.m_128441_("yDegree")) {
                    holder.setYDegree(this.tag.m_128451_("yDegree"));
                }
                if (this.tag.m_128441_("Scale")) {
                    holder.setScale(this.tag.m_128451_("Scale"));
                }
                if (this.tag.m_128441_("Y")) {
                    holder.setY(this.tag.m_128451_("Y"));
                }
                if (this.tag.m_128441_("XZ")) {
                    holder.setXZ(this.tag.m_128451_("XZ"));
                }
                if (this.tag.m_128441_("defaultValues")) {
                    holder.setDefaultValues(this.tag.m_128471_("defaultValues"));
                }
                holder.m_6596_();
                player.m_9236_().m_7260_(this.pos, be.m_58900_(), be.m_58900_(), 3);
            }
            if (be instanceof GlassClocheBlockEntity) {
                holder = (GlassClocheBlockEntity)be;
                if (this.tag.m_128441_("Scale")) {
                    holder.setScale(this.tag.m_128451_("Scale"));
                }
                if (this.tag.m_128441_("defaultValues")) {
                    holder.setDefaultValues(this.tag.m_128471_("defaultValues"));
                }
                holder.m_6596_();
                player.m_9236_().m_7260_(this.pos, be.m_58900_(), be.m_58900_(), 3);
            }
        });
    }
}

