/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fetzi.recipe.WorkbenchRecipe;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class WorkbenchRecipeSerializer
implements RecipeSerializer<WorkbenchRecipe> {
    public static final WorkbenchRecipeSerializer INSTANCE = new WorkbenchRecipeSerializer();
    public static final ResourceLocation ID = new ResourceLocation("fetzisdisplays", "workbench");

    public WorkbenchRecipe fromJson(ResourceLocation id, JsonObject json) {
        JsonObject ing = json.getAsJsonObject("ingredient");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)ing);
        int amount = ing.has("amount") ? ing.get("amount").getAsInt() : 1;
        ResourceLocation resId = new ResourceLocation(json.get("result").getAsString());
        Item resultItem = (Item)BuiltInRegistries.f_257033_.m_7745_(resId);
        int count = json.has("count") ? json.get("count").getAsInt() : 1;
        ItemStack output = new ItemStack((ItemLike)resultItem, count);
        return new WorkbenchRecipe(id, ingredient, amount, output);
    }

    public WorkbenchRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        Ingredient ing = Ingredient.m_43940_((FriendlyByteBuf)buf);
        int amount = buf.m_130242_();
        ItemStack output = buf.m_130267_();
        return new WorkbenchRecipe(id, ing, amount, output);
    }

    public void toNetwork(FriendlyByteBuf buf, WorkbenchRecipe recipe) {
        recipe.getIngredient().m_43923_(buf);
        buf.m_130130_(recipe.getAmount());
        buf.m_130055_(recipe.m_8043_(null));
    }
}

