/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.screen;

import io.github.fetzi.menu.WorkbenchMenu;
import io.github.fetzi.recipe.WorkbenchRecipe;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class WorkbenchScreen
extends AbstractContainerScreen<WorkbenchMenu> {
    private static final ResourceLocation GUI = new ResourceLocation("textures/gui/container/stonecutter.png");
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_ROWS = 3;
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 16;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int SCROLLER_FULL_HEIGHT = 54;
    private static final int RECIPES_X = 52;
    private static final int RECIPES_Y = 14;
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public WorkbenchScreen(WorkbenchMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        menu.registerUpdateListener(this::containerChanged);
        --this.f_97729_;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.m_280218_(GUI, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int scrollY = (int)(54.0f * this.scrollOffs);
        guiGraphics.m_280218_(GUI, this.f_97735_ + 119, this.f_97736_ + 15 + scrollY, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int x = this.f_97735_ + 52;
        int y = this.f_97736_ + 14;
        int end = this.startIndex + 12;
        this.renderButtons(guiGraphics, x, y, end);
        this.renderRecipes(guiGraphics, x, y, end);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.displayRecipes) {
            int x = this.f_97735_ + 52;
            int y = this.f_97736_ + 14;
            int end = this.startIndex + 12;
            List<WorkbenchRecipe> list = ((WorkbenchMenu)this.f_97732_).getRecipes();
            for (int i = this.startIndex; i < end && i < ((WorkbenchMenu)this.f_97732_).getNumRecipes(); ++i) {
                int idx = i - this.startIndex;
                int px = x + idx % 4 * 16;
                int py = y + idx / 4 * 18 + 2;
                if (mouseX < px || mouseX >= px + 16 || mouseY < py || mouseY >= py + 18) continue;
                guiGraphics.m_280153_(this.f_96547_, list.get(i).m_8043_(this.f_96541_.f_91073_.m_9598_()), mouseX, mouseY);
            }
        }
    }

    private void renderButtons(GuiGraphics guiGraphics, int x, int y, int end) {
        for (int i = this.startIndex; i < end && i < ((WorkbenchMenu)this.f_97732_).getNumRecipes(); ++i) {
            int idx = i - this.startIndex;
            int px = x + idx % 4 * 16;
            int py = y + idx / 4 * 18 + 2;
            int v = this.f_97727_;
            if (i == ((WorkbenchMenu)this.f_97732_).getSelectedRecipeIndex()) {
                v += 18;
            } else if (this.m_6774_(px, py, 16, 18, this.f_96541_.f_91067_.m_91589_(), this.f_96541_.f_91067_.m_91594_())) {
                v += 36;
            }
            guiGraphics.m_280218_(GUI, px, py - 1, 0, v, 16, 18);
        }
    }

    private void renderRecipes(GuiGraphics guiGraphics, int x, int y, int end) {
        List<WorkbenchRecipe> list = ((WorkbenchMenu)this.f_97732_).getRecipes();
        for (int i = this.startIndex; i < end && i < ((WorkbenchMenu)this.f_97732_).getNumRecipes(); ++i) {
            int idx = i - this.startIndex;
            int px = x + idx % 4 * 16;
            int py = y + idx / 4 * 18 + 2;
            guiGraphics.m_280480_(list.get(i).m_8043_(this.f_96541_.f_91073_.m_9598_()), px, py);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int x = this.f_97735_ + 52;
            int y = this.f_97736_ + 14;
            int end = this.startIndex + 12;
            for (int i = this.startIndex; i < end; ++i) {
                int idx = i - this.startIndex;
                double dx = mouseX - (double)(x + idx % 4 * 16);
                double dy = mouseY - (double)(y + idx / 4 * 18);
                if (!(dx >= 0.0) || !(dy >= 0.0) || !(dx < 16.0) || !(dy < 18.0) || !((WorkbenchMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, i)) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((WorkbenchMenu)this.f_97732_).f_38840_, i);
                return true;
            }
            int sx = this.f_97735_ + 119;
            int sy = this.f_97736_ + 9;
            if (mouseX >= (double)sx && mouseX < (double)(sx + 12) && mouseY >= (double)sy && mouseY < (double)(sy + 54)) {
                this.scrolling = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int top = this.f_97736_ + 14;
            int bottom = top + 54;
            this.scrollOffs = ((float)mouseY - (float)top - 7.5f) / (float)(bottom - top - 15);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = ((((WorkbenchMenu)this.f_97732_).getNumRecipes() + 4 - 1) / 4 - 3) * 4;
            this.startIndex = (int)(this.scrollOffs * (float)this.startIndex);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isScrollBarActive()) {
            int rows = (((WorkbenchMenu)this.f_97732_).getNumRecipes() + 4 - 1) / 4 - 3;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - (float)delta / (float)rows), (float)0.0f, (float)1.0f);
            this.startIndex = (int)(this.scrollOffs * (float)rows) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((WorkbenchMenu)this.f_97732_).getNumRecipes() > 12;
    }

    private void containerChanged() {
        this.displayRecipes = ((WorkbenchMenu)this.f_97732_).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }
}

