/*
 * Decompiled with CFR 0.152.
 */
package io.github.fetzi.util;

import dev.architectury.event.events.client.ClientGuiEvent;
import io.github.fetzi.config.FetzisDisplaysConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class FetzisDisplaysOverlay {
    private static final ResourceLocation PROTRACTOR_ICON = new ResourceLocation("fetzisdisplays", "textures/item/protractor.png");
    private static final ResourceLocation MAGNIFYING_GLASS_ICON = new ResourceLocation("fetzisdisplays", "textures/item/magnifying_glass.png");
    private static final ResourceLocation RULER_ICON = new ResourceLocation("fetzisdisplays", "textures/item/ruler.png");

    public static void cycleHudCorner() {
        HudCorner next = HudCorner.values()[(FetzisDisplaysConfig.getItemGUIPos().ordinal() + 1) % HudCorner.values().length];
        FetzisDisplaysConfig.setItemGUIPos(next);
    }

    public static void register() {
        ClientGuiEvent.RENDER_HUD.register((graphics, tickDelta) -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return;
            }
            ItemStack stack = mc.f_91074_.m_21205_();
            if (stack.m_41619_()) {
                return;
            }
            int screenWidth = mc.m_91268_().m_85445_();
            int screenHeight = mc.m_91268_().m_85446_();
            int iconSize = 16;
            int textOffsetX = 20;
            int baseX = 4;
            int baseY = 10;
            HudCorner currentHudCorner = FetzisDisplaysConfig.getItemGUIPos();
            switch (currentHudCorner.ordinal()) {
                case 1: {
                    baseX = screenWidth - iconSize - baseX;
                    textOffsetX = -iconSize - 68;
                    break;
                }
                case 2: {
                    baseY = screenHeight - iconSize - baseY;
                    break;
                }
                case 3: {
                    baseX = screenWidth - iconSize - baseX;
                    baseY = screenHeight - iconSize - baseY;
                    textOffsetX = -iconSize - 68;
                }
            }
            if (stack.m_41720_().m_5524_().contains("protractor")) {
                String mode;
                graphics.m_280163_(PROTRACTOR_ICON, baseX, baseY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                int angle = stack.m_41784_().m_128451_("scroll_angle");
                if (currentHudCorner.equals((Object)HudCorner.TOP_RIGHT) || currentHudCorner.equals((Object)HudCorner.BOTTOM_RIGHT)) {
                    textOffsetX += 4;
                }
                if ((mode = stack.m_41784_().m_128461_("scroll_mode")).equals("zAxis")) {
                    graphics.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"tooltip.protractor.mode", (Object[])new Object[]{Component.m_237115_((String)"tooltip.protractor.zAxis")}), baseX + textOffsetX, baseY, 0xFFFFFF, true);
                } else if (mode.equals("xAxis")) {
                    graphics.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"tooltip.protractor.mode", (Object[])new Object[]{Component.m_237115_((String)"tooltip.protractor.xAxis")}), baseX + textOffsetX, baseY, 0xFFFFFF, true);
                } else if (mode.equals("yAxis")) {
                    graphics.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"tooltip.protractor.mode", (Object[])new Object[]{Component.m_237115_((String)"tooltip.protractor.yAxis")}), baseX + textOffsetX, baseY, 0xFFFFFF, true);
                }
                graphics.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"tooltip.protractor.1", (Object[])new Object[]{angle}), baseX + textOffsetX, baseY + 10, 0xFFFFFF, true);
            }
            if (stack.m_41720_().m_5524_().contains("magnifying_glass")) {
                graphics.m_280163_(MAGNIFYING_GLASS_ICON, baseX, baseY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                int scale = stack.m_41784_().m_128451_("scroll_scale");
                if (currentHudCorner.equals((Object)HudCorner.TOP_RIGHT) || currentHudCorner.equals((Object)HudCorner.BOTTOM_RIGHT)) {
                    textOffsetX += 28;
                }
                graphics.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"tooltip.magnifying_glass.1", (Object[])new Object[]{scale}), baseX + textOffsetX, baseY + 4, 0xFFFFFF, true);
            }
            if (stack.m_41720_().m_5524_().contains("ruler")) {
                graphics.m_280163_(RULER_ICON, baseX, baseY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                float xzOff = stack.m_41784_().m_128457_("scroll_xz");
                float yOff = stack.m_41784_().m_128457_("scroll_y");
                String mode = stack.m_41784_().m_128461_("scroll_mode");
                if (mode.equals("vertical")) {
                    graphics.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"tooltip.ruler.mode", (Object[])new Object[]{Component.m_237115_((String)"tooltip.ruler.ver")}), baseX + textOffsetX, baseY - 6, 0xFFFFFF, true);
                } else if (mode.equals("horizontal")) {
                    graphics.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"tooltip.ruler.mode", (Object[])new Object[]{Component.m_237115_((String)"tooltip.ruler.hor")}), baseX + textOffsetX, baseY - 6, 0xFFFFFF, true);
                }
                graphics.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"tooltip.ruler.1", (Object[])new Object[]{Float.valueOf(xzOff / 100.0f)}), baseX + textOffsetX, baseY + 4, 0xFFFFFF, true);
                graphics.m_280614_(mc.f_91062_, (Component)Component.m_237110_((String)"tooltip.ruler.2", (Object[])new Object[]{Float.valueOf(yOff / 100.0f)}), baseX + textOffsetX, baseY + 14, 0xFFFFFF, true);
            }
        });
    }

    public static enum HudCorner {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

